﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;
using System.Collections.Generic;
using System.IO;
using System.Xml;

namespace Sasa.QualityTools.DrFx.Core.Translation
{
    public static class DrFxRuleLoader
    {
        private const string resourceName = "Sasa.QualityTools.DrFx.Core.Resources.DrFxRules.xml";



        /// <summary>
        /// アセンブリに埋め込まれている翻訳ルールコンテンツを解析し、翻訳ルールコレクションを作成します。
        /// </summary>
        /// <returns>翻訳ルールコレクション。</returns>
        public static IEnumerable<DrFxRule> Load()
        {
            using (Stream stream = typeof(DrFxRuleLoader).Assembly.GetManifestResourceStream(resourceName))
            {
                return Load(stream);
            }
        }

        /// <summary>
        /// 指定されたストリームから翻訳ルールコンテンツを読み込んで解析し、翻訳ルールコレクションを作成します。
        /// </summary>
        /// <param name="stream">翻訳ルールコンテンツ読み込み用ストリーム。</param>
        /// <returns>翻訳ルールコレクション。</returns>
        internal static IEnumerable<DrFxRule> Load(Stream stream)
        {
            List<DrFxRule> rules = new List<DrFxRule>();

            XmlDocument doc = new XmlDocument();
            doc.Load(stream);

            foreach (XmlNode ruleNode in doc.SelectNodes("/Rules/Rule"))
            {
                DrFxRule rule = new DrFxRule();
                rule.CheckId = ruleNode.Attributes["CheckId"].Value;
                rule.Category = ruleNode.Attributes["Category"].Value;
                rule.Name = ruleNode["Name"].InnerText;

                foreach (XmlNode resolutionNode in ruleNode.SelectNodes("Resolution"))
                {
                    Resolution resolution = new Resolution();
                    resolution.Content = resolutionNode["Content"].InnerText;
                    resolution.Pattern = resolutionNode["Pattern"].InnerText;
                    rule.Resolutions.Add(resolution);
                }
                
                rules.Add(rule);
            }

            return rules;
        }
    }
}
