﻿using System;
using System.IO;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Design
{
    // このクラスは CA1063:IDisposableReimplementation に違反しています。
    public class Rule1063A : StreamReader, IDisposable
    {
        private Stream stream;

        public Rule1063A(Stream stream)
            : base(stream)
        {
            this.stream = stream;
        }

        // このデストラクタは CA1063:FinalizeImplementation に違反しています。
        ~Rule1063A()
        {
            this.stream.Dispose();
        }

        // このメソッドは CA1063:DisposeImplementation and CA1063:RenameDispose に違反しています。
        void IDisposable.Dispose()
        {
            this.stream.Dispose();
            GC.SuppressFinalize(this);
        }
    }

    // このクラスは CA1063:ProvideDisposeBool に違反しています。
    public class Rule1063B : IDisposable
    {
        private Stream stream = new MemoryStream();

        // このメソッドは CA1063:DisposeImplementation に違反しています。
        public void Dispose()
        {
            this.stream.Dispose();
            GC.SuppressFinalize(this);
        }
    }

    public class Rule1063C : IDisposable
    {
        private Stream stream = new MemoryStream();

        // このメソッドは CA1063:DisposeBoolSignature に違反しています。
        public virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.stream.Dispose();
            }
        }

        // このメソッドは CA1063:DisposeSignature に違反しています。
        public virtual void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
    }
}
