﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;
using System.Runtime.Serialization;

namespace Sasa.QualityTools.DrFx.Console
{
    /// <summary>
    /// 定義されていないオプションが指定されたことを表す例外クラスです。
    /// </summary>
    [Serializable]
    internal class UndefinedOptionException : Exception
    {
        /// <summary>
        /// 指定された未定義オプション。
        /// </summary>
        internal string SpecifiedOption { get; private set; }



        /// <summary>
        /// 指定されたメッセージを使用して、インスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外に関する情報を表すメッセージ。</param>
        /// <param name="specifiedOption">指定された未定義オプション。</param>
        /// <param name="innerException">この例外が発生する原因となった例外。</param>
        internal UndefinedOptionException(string message, string specifiedOption, Exception innerException)
            : base(message, innerException)
        {
            SpecifiedOption = specifiedOption;
        }

        /// <summary>
        /// シリアライズされたデータを使用して、インスタンスを初期化します。
        /// </summary>
        /// <param name="info">シリアライズされたデータ。</param>
        /// <param name="context">シリアライズストリーミング。</param>
        protected UndefinedOptionException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }
    }
}
