﻿//  Copyright (c) 2010-2012, www.dvgtu.org
//  All rights reserved.

//  Redistribution and use in source and binary forms, with or without modification, 
//  are permitted provided that the following conditions are met:

//  * Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer. 
//  * Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution. 

//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
//  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
//  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
//  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
//  POSSIBILITY OF SUCH DAMAGE.
//$Id: AvatarState.cs 115 2011-10-29 14:01:18Z takeshich $

using System;
using OpenMetaverse;

namespace dvgtuViewer
{
	/// <summary>
	/// Description of AvatarState.
	/// </summary>
	public class AvatarState
	{
		private string myAvatarName;
		private UUID myAvatarID;
		private float myDistance;
		
		public AvatarState(float distance,UUID avatarID,string avatarName)
		{
			this.myDistance = distance;
			this.myAvatarID = avatarID;
			this.myAvatarName = avatarName;
		}
		
		public AvatarState(UUID avatarID,string avatarName)
		{
			this.myAvatarID = avatarID;
			this.myAvatarName = avatarName;
		}
		
		public string AvatarName
		{
			get { return myAvatarName; }
		}
		
		public UUID AvatarID
		{
			get { return myAvatarID; }
		}
		
		public float Distance
		{
			get { return myDistance; }
		}
		
		public override string ToString()
		{
			if (myDistance != 0.0f){
				return myAvatarName + "(" + myDistance.ToString() + "m)";
			}else{
				return myAvatarName;
			}
			
		}
	}
}
