﻿//  Copyright (c) 2010-2012, www.dvgtu.org
//  All rights reserved.

//  Redistribution and use in source and binary forms, with or without modification, 
//  are permitted provided that the following conditions are met:

//  * Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer. 
//  * Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution. 

//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
//  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
//  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
//  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
//  POSSIBILITY OF SUCH DAMAGE.
// $Id: ListForm.cs 133 2011-11-11 15:24:10Z takeshich $

using System;
using System.Collections;
using System.Drawing;
using System.Windows.Forms;
using System.Reflection;
using System.IO;
using System.Collections.Generic;
using WeifenLuo.WinFormsUI.Docking;
using OpenMetaverse;
using OpenMetaverse.Assets;
using dvgtuViewer.SLNetworkComm;
using System.Threading;


namespace dvgtuViewer
{
	/// <summary>
	/// Description of ListForm.
	/// </summary>
	public partial class ListForm : WeifenLuo.WinFormsUI.Docking.DockContent
	{
		private DvgtuInstance dvgtuInstance;
		private GridClient Client{ get { return dvgtuInstance.Client; } }
		private SLNetCom NetCom{ get { return dvgtuInstance.Netcom; } }

		private Dictionary<UUID, string> Key2Name = new Dictionary<UUID, string>();

		public ListForm(DvgtuInstance dvgtuInstance)
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
			this.dvgtuInstance = dvgtuInstance;
			this.Load += new EventHandler(ListForm_Load);
		}

		void ListForm_Load(object sender, EventArgs e)
		{
			//NetCom.NetcomSync = this;
			
			tabPage1.Select();
			
			//2.5秒おきに
			timer1.Interval = 2500;
			
			timer1.Enabled = true;
			timer1.Start();
		
			NetCom.TeleportStatusChanged += new EventHandler<TeleportEventArgs>(NetCom_TeleportStatusChanged);
			Client.Avatars.UUIDNameReply += new EventHandler<UUIDNameReplyEventArgs>(Client_Avatars_UUIDNameReply);
			
			
			tabList.SelectedIndexChanged += new EventHandler(tabList_SelectedIndexChanged);
			listAva.MouseDown += new MouseEventHandler(listAva_MouseDown);
			listFriend.MouseDown += new MouseEventHandler(listFriend_MouseDown);
		}

		void Client_Avatars_UUIDNameReply(object sender, UUIDNameReplyEventArgs e)
		{
			//settingFormでこのイベントが走るときにこちらに入ってしまう場合がある修正する必要がある
			return;
		}
		
		void ListForm_Disposed(object sender, EventArgs e)
		{
			NetCom.TeleportStatusChanged -= new EventHandler<TeleportEventArgs>(NetCom_TeleportStatusChanged);
			Client.Avatars.UUIDNameReply -= new EventHandler<UUIDNameReplyEventArgs>(Client_Avatars_UUIDNameReply);
		}

		void listFriend_MouseDown(object sender, MouseEventArgs e)
		{
			if ( e.Button == MouseButtons.Right )
	        {
	            //select the item under the mouse pointer
	            listFriend.SelectedIndex = listFriend.IndexFromPoint( e.Location );
	      
	            if ( listFriend.SelectedIndex != -1)
	            {
	            	//MessageBox.Show("X:" + e.X.ToString() + ",Y:" + e.Y.ToString());
	            	int PosX = System.Windows.Forms.Form.MousePosition.X - (this.DesktopLocation.X + this.DockPanel.Location.X);
	            	int PosY = System.Windows.Forms.Form.MousePosition.Y - (this.DesktopLocation.Y + this.DockPanel.Location.Y);
	            	contextMenuStrip1.Show(PosX,PosY);
	            }                
	        }
		}

		void listAva_MouseDown(object sender, MouseEventArgs e)
		{
			if ( e.Button == MouseButtons.Right )
	        {
	            //select the item under the mouse pointer
	            listAva.SelectedIndex = listAva.IndexFromPoint( e.Location );
	            
	            if ( listAva.SelectedIndex != -1)
	            {
	            	//MessageBox.Show("X:" + e.X.ToString() + ",Y:" + e.Y.ToString());
	            	//int PosX = ParentForm.Location.X + (ParentForm.Width - 270 ) + listAva.Location.X + tabList.Location.X + e.X  ;
	            	int PosX = System.Windows.Forms.Form.MousePosition.X - (this.DesktopLocation.X + this.DockPanel.Location.X);
	            	//int PosX = e.X;
	            	//TODO:dockstyleによって得られる座標が微妙に違うようになっているので調査する
	            	
	            	int PosY = System.Windows.Forms.Form.MousePosition.Y -
//	            		ParentForm.Location.Y
//	            		+ DockPanel.Location.Y 
//	            		 ListForm.ActiveForm.Location.Y
//	            		+ this.ContextMenuStrip.Location.Y
//	            		+ 12
//	            		+ listAva.Location.Y
//	            		+ e.Y
//	            		+ toolStripMenuItem1.Size.Height 
//	            		+ contextMenuStrip1.ImageScalingSize.Height;
	            		(this.DesktopLocation.Y
	            		+ this.DockPanel.Location.Y
	            		// + tabList.Location.Y
	            		//+ ListForm.ActiveForm.Location.Y
	            		//+ listAva.Location.Y
	            		);
	            	Logger.Log("System.Windows.Forms.Form.MousePosition.Y:" + System.Windows.Forms.Form.MousePosition.Y.ToString()
	            	           + "ListForm.ActiveForm.Location.Y:" + ListForm.ActiveForm.Location.Y.ToString()
	            	           + "listAva.Location.Y:" + listAva.Location.Y.ToString()
	            	           + "e.Y:" + e.Y.ToString()
	            	           + "toolStripMenuItem1.Size.Height:" + toolStripMenuItem1.Size.Height.ToString()
	            	           + "contextMenuStrip1.ImageScalingSize.Height:" + contextMenuStrip1.ImageScalingSize.Height.ToString()
	            	           ,OpenMetaverse.Helpers.LogLevel.Debug);
	            	contextMenuStrip1.Show(PosX,PosY);
	            }                
	        }
		}

		void NetCom_TeleportStatusChanged(object sender, TeleportEventArgs e)
		{
			try{
				switch(e.Status){
					case TeleportStatus.Finished:
						GetCurrentSimAvatorList();
						GetFriendList();
						break;
					default:
						break;
				}
			}catch(Exception exp){
				Logger.Log("ListForm_NetCom_TeleportStatusChanged:" + exp.Message,OpenMetaverse.Helpers.LogLevel.Error);
			}
		}

		void tabList_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (!NetCom.IsLoggedIn) return;
			
			if (tabList.SelectedIndex == 0){
				GetCurrentSimAvatorList();
			}
			else{
				GetFriendList();
			}
		}
		
		private void GetCurrentSimAvatorList()
		{
			try{
				float Distination = 0f;
				
				SortedDictionary<float, UUID> NearyAva = new SortedDictionary<float, UUID>();
				NearyAva.Clear();
				
				ArrayList NearyAvatar = new ArrayList();
				NearyAvatar.Clear();			
				
				//ご近所さんをかき集める
				Client.Network.CurrentSim.ObjectsAvatars.ForEach(delegate(Avatar Ava){
			                                                 	
			                                                 		//距離計算
			                                                 		Client.Network.CurrentSim.AvatarPositions.ForEach(delegate(KeyValuePair<UUID, Vector3> kvp){
			                                                 		                                                  	if (kvp.Key == Ava.ID){
			                                                 		                                                  		Distination = Vector3.Distance(kvp.Value,Client.Self.SimPosition);
			                                                 		                                                  	}
			                                                 		                                                  });
			                                                 		if (Ava.ID != Client.Self.AgentID){
				                                                 		//UUIDと名前の格納
				                                                 		if (Ava.ID != UUID.Zero){
				                                                 			if (!Key2Name.ContainsKey(Ava.ID)){
				                                                 				Key2Name.Add(Ava.ID,Ava.Name);
				                                                 			}
				                                                 		}
	
				                                                 		//Logger.Log("Distination:" + Distination.ToString(),OpenMetaverse.Helpers.LogLevel.Debug);
				                                                 		
				                                                 		//距離でソートできる入れ物に格納
				                                                 		if (Distination != 0f){
				                                                 			if (NearyAva.ContainsKey(Distination)){
				                                                 				//有効桁は小数点５桁なのだろうか？
				                                                 				Distination = Distination + 0.00001f;
				                                                 			}
				                                                 			NearyAva.Add(Distination,Ava.ID);
				                                                 			//Logger.Log("Distination:" + Distination.ToString() + "UUID:" + Ava.ID.ToString(),OpenMetaverse.Helpers.LogLevel.Debug);
				                                                 		}
			                                                 		}
				                                                 });
				
				//距離でソートされたUUIDから名前を引きながら、ListBoxに入れるべきDataSourceの元を作成
				foreach(KeyValuePair<float, UUID> kvps in NearyAva){
					string AvaName2Key;
					Key2Name.TryGetValue(kvps.Value,out AvaName2Key);
					NearyAvatar.Add(new AvatarState(kvps.Key,kvps.Value,AvaName2Key + "(" + (int)kvps.Key + "m)"));
				}

				//ご近所さんがいない場合
				if(NearyAvatar.Count == 0){
					listAva.DataSource = null;
					listAva.DisplayMember = null;
					listAva.ValueMember = null;
					return;
				}else{
					//いる場合
					listAva.DataSource = NearyAvatar;
					listAva.DisplayMember = "AvatarName";
					listAva.ValueMember = "AvatarID";
				}
				
			}catch(Exception ex){
				Logger.Log("ListForm_GetCurrentSimAvatorList:" + ex.Message,OpenMetaverse.Helpers.LogLevel.Error);
			}
				
		}
		
		private void GetFriendList()
		{
			
			ArrayList LineAva = new ArrayList();
			
			//オンラインの人の入れ物
			SortedDictionary<string,UUID> OnlineAva = new SortedDictionary<string,UUID>();
			
			//オフラインの人の入れ物
			SortedDictionary<string,UUID> OfflineAva = new SortedDictionary<string,UUID>();

			OnlineAva.Clear();
			OfflineAva.Clear();
			
			Client.Friends.FriendList.ForEach(delegate(FriendInfo friendInfo){
			                                  	//listをonlineとofflineに分けて格納
			                                  	if (friendInfo.IsOnline){
			                                  		if (friendInfo.Name != string.Empty){
			                                  			OnlineAva.Add(friendInfo.Name,friendInfo.UUID);
			                                  		}
			                                  	}else{
			                                  		if (friendInfo.Name != string.Empty){
			                                  			OfflineAva.Add(friendInfo.Name,friendInfo.UUID);
			                                  		}
			                                  	}
			                                
			                                  	
			                                  	if (friendInfo.UUID != UUID.Zero){
                                         			if (!Key2Name.ContainsKey(friendInfo.UUID)){
                                         				Key2Name.Add(friendInfo.UUID,friendInfo.Name);
                                         			}
                                         		}
			                                  	
			                                  	});
			
			foreach(KeyValuePair<string, UUID> kvpOnline in OnlineAva){
				LineAva.Add(new AvatarState(0f,kvpOnline.Value,kvpOnline.Key));
			}
			foreach(KeyValuePair<string, UUID> kvpOffline in OfflineAva){
				LineAva.Add(new AvatarState(0f,kvpOffline.Value,kvpOffline.Key));
			}
			
			//友達がいない場合
			//removeされて0人になる場合でもイベントが存在しないが、ロジックは入れておく
			if (LineAva.Count == 0){
				listFriend.DataSource = null;
				listFriend.DisplayMember = null;
				listFriend.ValueMember = null;
				return;
			}else{
				//いる場合
				listFriend.DataSource = LineAva;
				listFriend.DisplayMember = "AvatarName";
				listFriend.ValueMember = "AvatarID";
			}
			
			
		}
		
		
		void Timer1Tick(object sender, EventArgs e)
		{
			if (!NetCom.IsLoggedIn) return;
			
			//listAvaとlistFriendが選択されているなら、その場所を保存
			ArrayList ListAvatarDs = new ArrayList();
			ArrayList ListFriendDs = new ArrayList();
			
			UUID ListAvaSelectedUUID = UUID.Zero;
			UUID ListFriendSelectedUUID= UUID.Zero;
			
			bool ListAvatarNotFound = false;
			
			if (tabList.SelectedIndex == 0){
				//selectedのままにする処理
				if (listAva.SelectedIndex != -1){
					ListAvaSelectedUUID = (UUID)listAva.SelectedValue;
				}
				
				GetCurrentSimAvatorList();
				
				if (listAva.SelectedIndex != -1){
					ListAvatarDs = (ArrayList)listAva.DataSource;
					int i=0;
					foreach(AvatarState avstate in ListAvatarDs){
						if(avstate.AvatarID != ListAvaSelectedUUID){
							ListAvatarNotFound = true;
						}
						else{
							ListAvatarNotFound = false;
							break;
						}
						i++;
					}
					
					if (ListAvatarNotFound){
						listAva.SelectedIndex = -1;
					}else{
						listAva.SelectedIndex = i;
					}
					
				}
			}
			else{
				if (listFriend.SelectedIndex != -1){
					ListFriendSelectedUUID = (UUID)listFriend.SelectedValue;
				}
				
				GetFriendList();
				
				if (listFriend.SelectedIndex != -1){
					ListFriendDs = (ArrayList)listFriend.DataSource;
					int i=0;
					foreach(AvatarState avstate in ListFriendDs){
						if(avstate.AvatarID != ListFriendSelectedUUID){
							ListAvatarNotFound = true;
						}
						else{
							ListAvatarNotFound = false;
							break;
						}
						i++;
					}
					
					if (ListAvatarNotFound){
						listFriend.SelectedIndex = -1;
					}else{
						listFriend.SelectedIndex = i;
					}
				}
			}
		}
		
		void ToolStripMenuItem1Click(object sender, EventArgs e)
		{
			UUID AvatarID;

			try{
				if (!NetCom.IsLoggedIn) return;
				if (tabList.SelectedIndex == 0){
					AvatarID = (UUID)listAva.SelectedValue;
				}else{
					AvatarID = (UUID)listFriend.SelectedValue;
				}
				
				//Logger.Log(AvatarID.ToString(),OpenMetaverse.Helpers.LogLevel.Debug);
				
				Rectangle RBounds = new Rectangle(398, 319, 398, 373);

				ProfileForm profileForm = new ProfileForm(dvgtuInstance);
				profileForm.SetAvatarID(AvatarID);
			
				//profileFormのサイズを指定してあげたい
				profileForm.Show(DockPanel,RBounds);
				//profileForm.Dispose();

				
			}catch(Exception exp){
				Logger.Log("ListFrom_ToolStripMenuItem1Click:" + exp.Message,OpenMetaverse.Helpers.LogLevel.Error);
			}
			
		}

		
		void ToolStripMenuItem2Click(object sender, EventArgs e)
		{
			UUID AvatarID;
			string AvatarName;

			if (!NetCom.IsLoggedIn) return;
			
			if (tabList.SelectedIndex == 0){
				AvatarID = (UUID)listAva.SelectedValue;
				Key2Name.TryGetValue(AvatarID,out AvatarName);
			}else{
				AvatarID = (UUID)listFriend.SelectedValue;
				Key2Name.TryGetValue(AvatarID,out AvatarName);
			}

			dvgtuInstance.chatForm.IMPreparate(AvatarID,AvatarName);
			
		}
	}
}
