﻿//  Copyright (c) 2010-2012, www.dvgtu.org
//  All rights reserved.

//  Redistribution and use in source and binary forms, with or without modification, 
//  are permitted provided that the following conditions are met:

//  * Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer. 
//  * Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution. 

//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
//  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
//  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
//  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
//  POSSIBILITY OF SUCH DAMAGE.
// $Id: LoginForm.cs 123 2011-11-06 08:03:34Z takeshich $

using System;
using System.Drawing;
using System.IO;
using System.Reflection;
using System.Windows.Forms;
using OpenMetaverse;
using dvgtuViewer.SLNetworkComm;
using WeifenLuo.WinFormsUI.Docking;


namespace dvgtuViewer
{
	/// <summary>
	/// Description of MainForm.
	/// </summary>
	public partial class LoginForm : WeifenLuo.WinFormsUI.Docking.DockContent
	{
		const string AGENT_NAME = "dvgtuViewer";
		const string AGENT_VERSION = "0.0.15";
		const string AUTHOR = "www.dvgtu.org";
		
		private bool isPasswordLoaded = false;
		private bool isPasswordChanged = false;
		
		private DvgtuInstance dvgtuInstance;
		private GridClient Client{ get { return dvgtuInstance.Client; } }
		private SLNetCom NetCom{ get { return dvgtuInstance.Netcom; } }
		
		public LoginForm(DvgtuInstance dvgtuInstance)
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
			this.dvgtuInstance = dvgtuInstance;
			this.AcceptButton = this.BtnLogin;
			
			this.Load += new EventHandler(LoginForm_Load);
			
		}

		
//		public void SetClient(GridClient client){
//			Client = client;
//		}
//		
//		public void SetNetCom(SLNetCom netCom){
//			NetCom = netCom;
//		}

		void radioStartLocationHome_CheckedChanged(object sender, EventArgs e)
		{
			if (radioStartLocationCustom.Checked){
				txtSimName.Visible = true;
				numUDX.Visible = true;
				numUDY.Visible = true;
				numUDZ.Visible = true;
			}else{
				txtSimName.Visible = false;
				numUDX.Visible = false;
				numUDY.Visible = false;
				numUDZ.Visible = false;
			}
		}

		void radioStartLocationLast_CheckedChanged(object sender, EventArgs e)
		{
			if (radioStartLocationCustom.Checked){
				txtSimName.Visible = true;
				numUDX.Visible = true;
				numUDY.Visible = true;
				numUDZ.Visible = true;
			}else{
				txtSimName.Visible = false;
				numUDX.Visible = false;
				numUDY.Visible = false;
				numUDZ.Visible = false;
			}
				
		}

		void cmbLoginGrid_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (cmbLoginGrid.SelectedIndex == 2){
				txtCustGridUri.Visible = true;
			}else
			{
				txtCustGridUri.Visible = false;
			}
				
		}

		void LoginForm_Load(object sender, EventArgs e)
		{
			Assembly asm = Assembly.GetEntryAssembly();
			string fullPath = asm.Location;

			//フル・パスからディレクトリ・パス部分を抽出する
			string dirPath = Path.GetDirectoryName(fullPath);
			string path =  dirPath + System.IO.Path.DirectorySeparatorChar + 
				"Settings.xml";

			//setting to initial value 
			radioStartLocationLast.Checked = true;
			cmbLoginGrid.SelectedIndex = 0;
			
			if (File.Exists(path)){
				//設定を読み込む
				Settings.LoadFromXmlFile();
				txtName.Text = Settings.Instance.FirstName + " " + Settings.Instance.LastName;
				txtPassword.Text = Settings.Instance.Password;
				txtCustGridUri.Text = Settings.Instance.CustomUri;
				cmbLoginGrid.SelectedIndex = Settings.Instance.GridType;
				txtSimName.Text = Settings.Instance.SimName;
				numUDX.Text = Settings.Instance.SimX;
				numUDY.Text = Settings.Instance.SimY;
				numUDZ.Text = Settings.Instance.SimZ;
				
				switch(Settings.Instance.StartLocation){
					case "last":
							radioStartLocationLast.Checked = true;
							break;
					case "home":
							radioStartLocationHome.Checked = true;
							break;
					case "custom":
							radioStartLocationCustom.Checked = true;
							break;
					default:
							break;
				}
				
			}
				
			if (Settings.Instance.Password != string.Empty){
				isPasswordLoaded = true;
			}
				
			if (!radioStartLocationCustom.Checked)
			{
				txtSimName.Visible = false;
				numUDX.Visible = false;
				numUDY.Visible = false;
				numUDZ.Visible = false;
			}
			
			if (cmbLoginGrid.SelectedIndex != 2){
				txtCustGridUri.Visible = false;
			}
			
			lblLoginStatus.Text = "ログアウトしています";
			//プラットフォームの取得
			//System.OperatingSystem os = System.Environment.OSVersion;
			//Logger.Log(os.Platform,OpenMetaverse.Helpers.LogLevel.Debug);
			
			cmbLoginGrid.SelectedIndexChanged += new EventHandler(cmbLoginGrid_SelectedIndexChanged);
			radioStartLocationLast.CheckedChanged += new EventHandler(radioStartLocationLast_CheckedChanged);
			radioStartLocationHome.CheckedChanged += new EventHandler(radioStartLocationHome_CheckedChanged);
			NetCom.ClientLoginStatus += new EventHandler<LoginProgressEventArgs>(NetCom_ClientLoginStatus);
		}
		
		void LoginForm_Disposed(object sender, EventArgs e)
		{
			NetCom.ClientLoginStatus -= new EventHandler<LoginProgressEventArgs>(NetCom_ClientLoginStatus);
		}

		void NetCom_ClientLoginStatus(object sender, LoginProgressEventArgs e)
		{
			switch(e.Status){
				case LoginStatus.Success:
					lblLoginStatus.Text = "ログイン成功";
					this.Close();
					break;
				case LoginStatus.ConnectingToLogin:
					lblLoginStatus.Text = "ログインしてます。";
					//Logger.Log("Connecting To Login...",OpenMetaverse.Helpers.LogLevel.Debug);
					break;
				case LoginStatus.ConnectingToSim:
					lblLoginStatus.Text = "シムに接続中";
					//Logger.Log("Connecting To Sim...",OpenMetaverse.Helpers.LogLevel.Debug);
					break;
				case LoginStatus.None:
					lblLoginStatus.Text = "ログアウトしています";
					//Logger.Log("logouted",OpenMetaverse.Helpers.LogLevel.Debug);
					break;
				case LoginStatus.Failed:
					lblLoginStatus.Text = "ログイン失敗";
					break;
				default:
					break;
			}
		}

		private string AccountConsistencyCheck(string AvatorName,string AvatorPassword){
        	
        	string avatorName = AvatorName;
        	int spaceCount;
        	
        	avatorName = avatorName.Trim();
			//整合性チェック1
			//文字列が入っているかチェック
			if (string.IsNullOrEmpty(avatorName)){
				return "AvatorNameNoEntry";
			}

			if (string.IsNullOrEmpty(AvatorPassword)){
				return "AvatorPasswordNoEntry";
			}

			//整合性チェック2
			//姓と名の間にスペースが含まれているかチェックする
			//1.文字列にひとつスペースが含まれていることで、OKとする。
			//TODO:Residentたいおう
			spaceCount = System.Array.FindAll(avatorName.ToCharArray(), delegate (char x) { return x == ' ';}).Length;
			
			if (spaceCount != 1){
				return "AvatorNamIncorrect";
			}
			
			return string.Empty;
		}
		
		private void BtnLoginClick(object sender, EventArgs e)
		{
			string avatorName = txtName.Text;
			string avatorPasswd = txtPassword.Text;
			string customGridUri = txtCustGridUri.Text;
			string firstName;
			string lastName;
			
			/// <summary>logincheck</summary>
			//if (NetCom.IsLoggingIn) return;
			
			/// <summary>consistencycheck</summary>
//			string AccConsistencyMessage = AccountConsistencyCheck(avatorName,avatorPasswd);
//			
//			switch (AccConsistencyMessage){
//				case "AvatorNameNoEntry":
//					txtPassword.Text = string.Empty;
//					avatorPasswd = string.Empty;
//					//TODO:多言語化の調査
//					MessageBox.Show("名前なし","注意");
//					txtName.Focus();
//					break;
//				case "AvatorPasswordNoEntry":
//					MessageBox.Show("passwordなし","注意");
//					txtPassword.Focus();
//					break;
//				case "AvatorNamIncorrect":
//					MessageBox.Show("名前不整合","注意");
//					txtName.Focus();
//					break;
//				default:
//					break;
//			}

			/// <summary>Separate the first and last name</summary>
			char[] delimiter = {' '};
			string[] arrName = avatorName.Split(delimiter);
			firstName = arrName[0];
			lastName = arrName[1];
			
			//パスワードをMD5で保存する
			// * パスワードがロードされない場合
			// * パスワードテキストエリアが変更された場合
			// * パスワード保存オプションがある場合

			//パスワードをMD5で保存しない
			// * パスワードがロードされていない場合
			// * パスワードが変更されていない場合
			// * パスワード保存オプションがない場合
			if (isPasswordChanged || !isPasswordLoaded){
				avatorPasswd = OpenMetaverse.Utils.MD5(avatorPasswd);	
			}
			
			//設定を保存する処理
			Settings.Instance.FirstName = firstName;
			Settings.Instance.LastName = lastName;
			Settings.Instance.Password = avatorPasswd;
			Settings.Instance.CustomUri = customGridUri;
			Settings.Instance.UserAgent = AGENT_NAME;
			Settings.Instance.UserAgentVesion = AGENT_VERSION;
			Settings.Instance.Author = AUTHOR;
			Settings.Instance.GridType = cmbLoginGrid.SelectedIndex;
			if (radioStartLocationLast.Checked)
				Settings.Instance.StartLocation = "last";
			if (radioStartLocationHome.Checked)
				Settings.Instance.StartLocation = "home";
			if (radioStartLocationCustom.Checked)
				Settings.Instance.StartLocation = "custom";
			Settings.Instance.SimName = txtSimName.Text;
			Settings.Instance.SimX = numUDX.Value.ToString();
			Settings.Instance.SimY = numUDY.Value.ToString();
			Settings.Instance.SimZ = numUDZ.Value.ToString();
			
			Settings.SaveToXmlFile();
			
			isPasswordChanged = false;

			//ログインするアカウント情報
			NetCom.LoginOptions.FirstName = firstName;
			NetCom.LoginOptions.LastName = lastName;
			NetCom.LoginOptions.Password = avatorPasswd;
			NetCom.LoginOptions.IsPasswordMD5 = true;

			//クライアント情報
			NetCom.LoginOptions.UserAgent = AGENT_NAME;
			NetCom.LoginOptions.Author = AUTHOR;
			//NetCom.LoginOptions.UserAgentVesion = AGENT_VERSION;

			if (radioStartLocationLast.Checked){
				NetCom.LoginOptions.StartLocation = StartLocationType.Last;
			}
				
			if (radioStartLocationHome.Checked){
				NetCom.LoginOptions.StartLocation = StartLocationType.Home;
			}
				
			if (radioStartLocationCustom.Checked){
				NetCom.LoginOptions.StartLocation = StartLocationType.Custom;
			}
			
			switch(cmbLoginGrid.SelectedIndex){
				case 0:
					//MainGrid
					NetCom.LoginOptions.Grid = LoginGrid.MainGrid;
					break;
				case 1:
					//BetaGrid
					NetCom.LoginOptions.Grid = LoginGrid.BetaGrid;
					break;
				case 2:
					//OpenSim
					NetCom.LoginOptions.Grid = LoginGrid.Custom;
					break;
				default:
					break;
			}
			
			//ログイン場所情報
			//OpenSimへの対応
			if ((NetCom.LoginOptions.Grid == LoginGrid.Custom)){
				
				if (string.IsNullOrEmpty(customGridUri)){
					//TODO:多言語対応
					MessageBox.Show("URI記述なし","注意");
					txtCustGridUri.Focus();
					return;
				}
				
				//URIをセット
				NetCom.LoginOptions.GridCustomLoginUri = customGridUri;
			}
			
			//スタート位置を選択できるようにする。場所を指定することも可能にする。
			if (NetCom.LoginOptions.StartLocation == StartLocationType.Custom){
				NetCom.LoginOptions.StartLocationCustom = txtSimName.Text + "/" +
					numUDX.Value.ToString() + "/" +
					numUDY.Value.ToString() + "/" +
					numUDZ.Value.ToString();
			}
			
			NetCom.Login();
		}
		
	}
}
