﻿/*!
@page codingRule SDXコーディング規約
 \n
@section はじめに
C++は良い言語ですが、他の言語と同様に複雑で最悪なコードを書ける言語でもあります。\n
無秩序にコードを書くと、バグを生みやすく、読みにくく、修正も拡張もしにくくなる可能性が上がります。\n
\n
<B>基本方針</B>\n
①C++初学者のための文法制限はしない\n
②最適化に頼れる所は頼り、無駄な最適化は避ける\n
③仮引数以外の日本語識別子は基本的に避ける\n
④細かい部分は常識で判断する\n
⑤規約に問題があれば見直しを行う\n
\n
<B>適用範囲</B>\n
SDXのみ対象です。\n
派生ライブラリやサンプルコードは命名規則に準拠せず、英語以外の識別子を必要な時に使います。\n
\n
<B>参考</B>\n
クラスライブラリ開発のデザインガイドライン\n
Google C++スタイルガイド\n
Effective C++（書籍）\n
\n
@section 命名規則
コードの一貫性を保つ上で、最も重要ですが常識に頼ると統一出来ない部分です\n
\n
<B>基本</B>\n
無理の無い範囲でわかりやすくする。一般的ではない省略は行わない。\n
\n
<B>ファイル名</B>\n
ヘッダーファイル名は、クラス名と同じにし拡張子は.hにし.hppにしない。\n
派生クラスをまとめて一つのファイルで実装している場合は、派生元のクラス名の前にDerivedをつけます。\n
\n
プリコンパイル用のヘッダーとソースはpre_compile.cpp、stdafx.hにして下さい。\n
\n
<B>仮引数</B>\n
原則的に日本語にします。\n
Unicode範囲内の特殊な記号は使いません\n
句読点などは規格非準拠なため使いません\n
\n
<B>仮引数以外の識別子</B>\n
それ以外は半角英数とアンダーバーで命名します\n
ローマ字表記は避け、英単語を元に命名します\n
\n
<B>大文字と小文字の使い分け</B>\n
先頭と単語の区切りを大文字にするのをPascal形式。\n
クラス、構造体、メンバー関数、列挙体、列挙子、ローカルで無い定数はPascal形式\n
\n
先頭を小文字にし単語の区切りを大文字にするのをCamel形式といいます。\n
ローカル変数とメンバー変数はCamel形式\n
\n
マクロはすべて大文字にして_で単語をつなぐ。ただし基本マクロは使わない。\n
\n
名前空間はライブラリ全体を覆うものは全て大文字、それ以外はPascalにします\n
\n
<B>慣用的な命名</B>\n
ループカウンタはi,j,kの順で一文字の変数を用いる\n
範囲ベースのループは for(auto it: 範囲ベース) とする\n
\n
@section スタイルの統一
<B>ヘッダーファイル</B>\n
基本的にはヘッダーファイルで実装と宣言をする。\n
実装が不可能な場合は実装と宣言を分ける\n
前方宣言で十分な場合、#includeを使わない\n
\n
<B>可変数引数</B>\n
可変数引数は使わず可変テンプレートを使います。\n
抽象クラスのメンバー関数に可変数引数が必要な場合は、可変テンプレートで初期化可能な型を引数にします\n
\n
<B>インライン関数</B>\n
inlineキーワードは使わず、コンパイラの判断にまかせる。\n
\n
<B>インクルードガード</B>\n
移植先の環境で使いたいコンパイラが全て#pragma onceを実装しているため。\n
#defineによるインクルードガードではなく、#pragma onceを使う。\n
\n
<B>条件式</B>\n
基本的に右側に定数が来るようにする\n
\n
<B>キャスト</B>\n
int,float,doubleの相互変換はcスタイルキャスト可。
それ以外はc++スタイルのキャストを使う。
\n
<B>goto</B>\n
禁止\n
\n
@section その他
<B>名前空間</B>\n
グローバルな変数は作らず、少なくともSDX名前空間に入れる。\n
using namespace std;などはサンプルコード以外で行わない\n
DxLib名前空間は省略しない\n
\n
<B>struct</B>\n
structはデータの取得と格納のみが必要な型に使う。\n
それ以外の機能が必要な場合はclassにする。\n
\n
<B>多重継承</B>\n
インターフェースの継承以外で多重継承は使わない。\n
\n
<B>仮想クラス</B>\n
純粋仮想関数を１つ以上持つクラスは、半角名の場合先頭にIをつけます。\n
メンバー変数を持っていてもIを付けます\n
\n
<B>アクセス制御</B>\n
公開する必要の無い、関数や変数はプライベートにする。\n
代入か取得の片方しかしないメンバー変数はプライベートにし、Get関数とSet関数を作る。\n
四則演算をするようなデータメンバーはパプリックにして公開する\n
\n
<B>宣言の順番</B>\n
調整中\n
\n
<B>入出力ストリーム、文字列ストリーム</B>\n
ライブラリ内部では使う、利用者は使用せずにライブラリを使えるようにする。\n
\n
<B>前置インクリメント</B>\n
最適化で速度的に差はほぼないが、前置インクリメントを使う\n
\n
<B>float型</B>\n
使わない\n
\n
<B>nullptr</B>\n
無効なポインタはNULLや0を使わずnullptrを使う
\n
<B>Boost</B>\n
標準ライブラリを優先して使い、必要な場合はboostを使う。\n
\n
<B>C++11</B>\n
VisualStudio2013で対応している範囲のみ使用可能。\n
C++14は不可\n
\n
<B>コメント</B>\n
ソースコード管理システムに登録されるような事は書かない。\n
仮引数と戻り値用のドキュメントコメントは使わない\n
関数とクラスには一行以上の説明を必ず付ける\n
クラスに対しては必ずサンプルコードを付ける\n
変数と列挙子は必要なら一行で説明をつける。コメントなしで分かる変数名にするのが良い。\n
\n
<B>実装コメント</B>\n
どうやっても分かりにくい場合、関数内部に説明のコメントをつける。\n
サンプルコードについては詳細に付けて良い\n
\n
<B>スペースとタブ</B>\n
タブ幅は4とし、半角スペースを使う\n
\n
<B>括弧</B>\n
括弧と括弧閉じは同じ高さ、あるいは同じ行にする。
例外としてelseを使う場合は以下の書き方にします。
@code
//ダメ
if( x == 1 ){
    func();
}
//良い
if( x == 1 )
{
    func();
}

//良い
if( x == 1 )
{
    func();
}else{
    func2();
}
@endcode
\n
*/
