﻿#pragma once
#include <Multimedia/SDX.h>
#include <Multimedia/Input.h>

namespace SDX
{
/** 一時停止処理する関数群.*/
/**	\include WaitSample.h*/
class Wait
{
private:
	Wait();
	~Wait();
public:
	/** 指定ミリ秒実行を停止.*/
	static void Timer(int 停止ミリ秒)
	{
	#ifdef DXLIB
		DxLib::WaitTimer(停止ミリ秒);
	#elif defined(SDL)
        SDL_Delay(停止ミリ秒);
	#endif
	}
	
	/** 垂直同期信号を指定回数待つ[DXLIB].*/
	static bool VSync(int 信号回数)
	{
	#ifdef DXLIB
		return !DxLib::WaitVSync(信号回数);	
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** キーを入力を待つ.*/
	static void PushKey()
	{
	#ifdef DXLIB
		DxLib::WaitKey();
	#elif defined(SDL)
        while (!Keyboard::HoldAnyKey() && System::ProcessMessage())
        {
        }
	#endif
	}
};
}
