#define WINVER 0x0500                                  /* o[W` Windows2000ȏ */
#define _WIN32_WINNT WINVER

#include "ruby.h"
#ifndef RUBY_ST_H
#include "st.h"
#endif

#define DXRUBY_EXTERN 1
#include "dxruby.h"
#include "sprite.h"
#include "image.h"
#include "collision.h"

static VALUE cSprite;         /* XvCgNX */

#define check_box_box(b1, b2) ( (b1)->x1 < (b2)->x2 && \
                                (b1)->y1 < (b2)->y2 && \
                                (b2)->x1 < (b1)->x2 && \
                                (b2)->y1 < (b1)->y2 )

#define check_point_box(x, y, x1, y1, x2, y2) ( (x) >= (x1) && \
                                                (y) >= (y1) && \
                                                (x) < (x2) && \
                                                (y) < (y2))

#define check_circle_circle(ox, oy, or, dx, dy, dr) ((or+dr) * (or+dr) >= (ox-dx) * (ox-dx) + (oy-dy) * (oy-dy))

#define check_circle_point(cx, cy, cr, px, py) ((cr*cr) >= (cx-px) * (cx-px) + (cy-py) * (cy-py))

//]ĂȂȉ~Ɖ~
//((cx1 - cx2).abs/((self.scale_x + s.scale_x) / 2.0))**2 + ((cy1 - cy2).abs/((self.scale_y + s.scale_y) / 2.0))**2 < (r1 + r2)**2

/*********************************************************************
 * Փ˔菈
 *
 *********************************************************************/

/* E{[쐬 */
#define volume_box( count, tx, ty, collision ) \
{\
    int i;\
    (collision)->x1 = (collision)->x2 = tx[0];\
    (collision)->y1 = (collision)->y2 = ty[0];\
\
    for( i = 1; i < count; i++ )\
    {\
        if( (collision)->x1 > tx[i] )\
        {\
            (collision)->x1 = tx[i];\
        }\
        if( (collision)->x2 < tx[i] )\
        {\
            (collision)->x2 = tx[i];\
        }\
        if( (collision)->y1 > ty[i] )\
        {\
            (collision)->y1 = ty[i];\
        }\
        if( (collision)->y2 < ty[i] )\
        {\
            (collision)->y2 = ty[i];\
        }\
    }\
}

/* S_Zo */
#define set_center( sprite, collision )\
{\
    struct DXRubyImage *image;\
    if( sprite->vcenter_x == Qnil || sprite->vcenter_y == Qnil )\
    {\
        DXRUBY_CHECK_IMAGE( sprite->vimage );\
        image = DXRUBY_GET_STRUCT( Image, sprite->vimage );\
        collision->center_x = sprite->vcenter_x == Qnil ? image->width / 2 : NUM2FLOAT(sprite->vcenter_x);\
        collision->center_y = sprite->vcenter_y == Qnil ? image->height / 2 : NUM2FLOAT(sprite->vcenter_y);\
    }\
    else\
    {\
        collision->center_x = NUM2FLOAT(sprite->vcenter_x);\
        collision->center_y = NUM2FLOAT(sprite->vcenter_y);\
    }\
}

/* _̉] */
#define rotation_point( collision, tx, ty, bx, by ) \
{\
    float angle = 3.141592653589793115997963468544185161590576171875f / 180.0f * collision->angle;\
    float sina = sin( angle );\
    float cosa = cos( angle );\
    float data1x = collision->scale_x * cosa;\
    float data1y = collision->scale_y * sina;\
    float data2x = collision->scale_x * sina;\
    float data2y = collision->scale_y * cosa;\
\
    tx = ((bx) - collision->center_x) * data1x - ((by) - collision->center_y) * data1y + collision->center_x + collision->base_x;\
    ty = ((bx) - collision->center_x) * data2x + ((by) - collision->center_y) * data2y + collision->center_y + collision->base_y;\
}

/* _̉](SwEXP[OȂ) */
#define rotation_point_out( centerx, centery, angle, x, y ) \
{\
    float rbangle = 3.141592653589793115997963468544185161590576171875f / 180.0f * (angle);\
    float sina = sin( rbangle );\
    float cosa = cos( rbangle );\
    float rbx = (x), rby = (y);\
\
    x = (rbx - (centerx)) * cosa - (rby - (centery)) * sina + (centerx);\
    y = (rbx - (centerx)) * sina + (rby - (centery)) * cosa + (centery);\
}

/* `ꎩg̉](XP[O) */
#define rotation_box( collision, tx, ty ) \
{\
    float angle = 3.141592653589793115997963468544185161590576171875f / 180.0f * collision->angle;\
    float sina = sin( angle );\
    float cosa = cos( angle );\
    float data1x = collision->scale_x * cosa;\
    float data1y = collision->scale_y * sina;\
    float data2x = collision->scale_x * sina;\
    float data2y = collision->scale_y * cosa;\
\
    tx[0] = (collision->bx1 - collision->center_x) * data1x - (collision->by1 - collision->center_y) * data1y + collision->center_x + collision->base_x;\
    ty[0] = (collision->bx1 - collision->center_x) * data2x + (collision->by1 - collision->center_y) * data2y + collision->center_y + collision->base_y;\
    tx[1] = (collision->bx2 - collision->center_x) * data1x - (collision->by1 - collision->center_y) * data1y + collision->center_x + collision->base_x;\
    ty[1] = (collision->bx2 - collision->center_x) * data2x + (collision->by1 - collision->center_y) * data2y + collision->center_y + collision->base_y;\
    tx[2] = (collision->bx2 - collision->center_x) * data1x - (collision->by2 - collision->center_y) * data1y + collision->center_x + collision->base_x;\
    ty[2] = (collision->bx2 - collision->center_x) * data2x + (collision->by2 - collision->center_y) * data2y + collision->center_y + collision->base_y;\
    tx[3] = (collision->bx1 - collision->center_x) * data1x - (collision->by2 - collision->center_y) * data1y + collision->center_x + collision->base_x;\
    ty[3] = (collision->bx1 - collision->center_x) * data2x + (collision->by2 - collision->center_y) * data2y + collision->center_y + collision->base_y;\
}

/* `̉]iSwEXP[OȂj */
#define rotation_box_out( centerx, centery, angle, x, y ) \
{\
    float rbangle = 3.141592653589793115997963468544185161590576171875f / 180.0f * angle;\
    float sina = sin( rbangle );\
    float cosa = cos( rbangle );\
    float rbx1 = x[0], rby1 = y[0], rbx2 = x[1], rby2 = y[1], rbx3 = x[2], rby3 = y[2], rbx4 = x[3], rby4 = y[3];\
\
    x[0] = (rbx1 - centerx) * cosa - (rby1 - centery) * sina + centerx;\
    y[0] = (rbx1 - centerx) * sina + (rby1 - centery) * cosa + centery;\
    x[1] = (rbx2 - centerx) * cosa - (rby2 - centery) * sina + centerx;\
    y[1] = (rbx2 - centerx) * sina + (rby2 - centery) * cosa + centery;\
    x[2] = (rbx3 - centerx) * cosa - (rby3 - centery) * sina + centerx;\
    y[2] = (rbx3 - centerx) * sina + (rby3 - centery) * cosa + centery;\
    x[3] = (rbx4 - centerx) * cosa - (rby4 - centery) * sina + centerx;\
    y[3] = (rbx4 - centerx) * sina + (rby4 - centery) * cosa + centery;\
}

/* `̊gEki]Ȃj */
#define scaling_box( collision, x, y ) \
{\
    x[0] = (collision->bx1 - collision->center_x) * collision->scale_x + collision->center_x + collision->base_x;\
    y[0] = (collision->by1 - collision->center_y) * collision->scale_y + collision->center_y + collision->base_y;\
    x[1] = (collision->bx2 - collision->center_x) * collision->scale_x + collision->center_x + collision->base_x;\
    y[1] = (collision->by1 - collision->center_y) * collision->scale_y + collision->center_y + collision->base_y;\
    x[2] = (collision->bx2 - collision->center_x) * collision->scale_x + collision->center_x + collision->base_x;\
    y[2] = (collision->by2 - collision->center_y) * collision->scale_y + collision->center_y + collision->base_y;\
    x[3] = (collision->bx1 - collision->center_x) * collision->scale_x + collision->center_x + collision->base_x;\
    y[3] = (collision->by2 - collision->center_y) * collision->scale_y + collision->center_y + collision->base_y;\
}


#define intersect(x1, y1, x2, y2, x3, y3, x4, y4) ( ((x1 - x2) * (y3 - y1) + (y1 - y2) * (x1 - x3)) * \
                                                    ((x1 - x2) * (y4 - y1) + (y1 - y2) * (x1 - x4)) )

#define checkline(x1, y1, x2, y2, x3, y3, x4, y4) ((((x1 - x2) * (y3 - y1) + (y1 - y2) * (x1 - x3)) * \
                                                    ((x1 - x2) * (y4 - y1) + (y1 - y2) * (x1 - x4)) < 0.0f) && \
                                                   (((x3 - x4) * (y1 - y3) + (y3 - y4) * (x3 - x1)) * \
                                                    ((x3 - x4) * (y2 - y3) + (y3 - y4) * (x3 - x2)) < 0.0f ))

struct Vector {
    float x;
    float y;
};


/*--------------------------------------------------------------------
    (p)OpƓ_̔
 ---------------------------------------------------------------------*/
/* E̎OpƓ_ */
static int checktriangle( float x, float y, float x1, float y1, float x2, float y2, float x3, float y3 )
{
    float cx, cy;

    if( (x1 - x3) * (y1 - y2) == (x1 - x2) * (y1 - y3) )
    {
        return 0;
    }

    cx = (x1 + x2 + x3) / 3; /* S_x */
    cy = (y1 + y2 + y3) / 3; /* S_y */

    if( intersect( x1, y1, x2, y2, x, y, cx, cy ) < 0.0f ||
        intersect( x2, y2, x3, y3, x, y, cx, cy ) < 0.0f ||
        intersect( x3, y3, x1, y1, x, y, cx, cy ) < 0.0f )
    {
        return 0;
    }
    return -1;
}


/*--------------------------------------------------------------------
    (p)~Ɛ̔
 ---------------------------------------------------------------------*/
/* ~Ɛ̔ */
static int checkCircleLine( float x, float y, float r, float x1, float y1, float x2, float y2 )
{
    float n1, n2, n3;
    /* v͐n_I_ */
    /* c͐n_~S */
    struct Vector v = {x2 - x1, y2 - y1};
    struct Vector c = {x - x1, y - y1};

    if( v.x == 0.0f && v.y == 0.0f )
    {
        return check_circle_point(x, y, r, x1, y1);
    }

    /* ̃xNg̓ς߂ */
    n1 = v.x * c.x + v.y * c.y;

    if( n1 < 0 )
    {
        /* c̒~̔a菬ꍇ͌Ă */
        return c.x*c.x + c.y*c.y < r * r ? -1 : 0;
    }

    n2 = v.x * v.x + v.y * v.y;

    if( n1 > n2 )
    {
        int len;
        /* ̏I_Ɖ~̒S̋̓߂ */
        len = (x2 - x)*(x2 - x) + (y2 - y)*(y2 - y);
        /* ~̔a̓ꍇ͌Ă */
        return  len < r * r ? -1 : 0;
    }
    else
    {
        n3 = c.x * c.x + c.y * c.y;
        return ( n3-(n1/n2)*n1 < r * r ) ? -1 : 0;
    }
    return 0;
}


int check( struct DXRubyCollision *o, struct DXRubyCollision *d )
{
    struct DXRubySprite *o_sprite = DXRUBY_GET_STRUCT( Sprite, o->vsprite );
    struct DXRubySprite *d_sprite = DXRUBY_GET_STRUCT( Sprite, d->vsprite );
    int o_type;
    int d_type;

    // E{[ĂȂΓĂȂ
    if( !check_box_box( o, d ) )
    {
        return FALSE;
    }

    // collisionȗ
    if( o_sprite->vcollision != Qnil )
    {
        o_type = RARRAY_LEN( o_sprite->vcollision );
    }
    else
    {
        o_type = 4;
    }

    if( d_sprite->vcollision != Qnil )
    {
        d_type = RARRAY_LEN( d_sprite->vcollision );
    }
    else
    {
        d_type = 4;
    }

    if( o_type == d_type )
    {// `̔r
        switch ( o_type )
        {
        case 4: // `
                // ŉ]

            if( o->rotation_flg || o->scaling_flg ) // o]Ă
            { // doSɉ]ċE{[rBĂȂΓĂȂB
                float ox[4], oy[4];
                float dx[4], dy[4];
                struct DXRubyCollision o_collision, d_collision;
                float centerx, centery;

                if( d->rotation_flg || d->scaling_flg ) // d]Ă
                {
                    // d̎pɉ]
                    rotation_box( d, dx, dy );
                }
                else // d͉]ĂȂ
                {
                    dx[0] = dx[3] = d->x1;
                    dy[0] = dy[1] = d->y1;
                    dx[1] = dx[2] = d->x2;
                    dy[2] = dy[3] = d->y2;
                }

                // oS_
                centerx = o->center_x + o->base_x;
                centery = o->center_y + o->base_y;

                // oS_𒆐Sd]
                rotation_box_out( centerx, centery, -o->angle, dx, dy )

                // dE{[쐬
                volume_box( 4, dx, dy, &d_collision );

                // õXP[O
                scaling_box( o, ox, oy );

                // oE{[쐬
                volume_box( 4, ox, oy, &o_collision );

                if( !check_box_box( &o_collision, &d_collision ) )
                {
                    return FALSE; // ĂȂ
                }
            }

            if( d->rotation_flg || d->scaling_flg ) // d]Ă
            { // odSɉ]ċE{[rBĂȂΓĂȂB
                float ox[4], oy[4];
                float dx[4], dy[4];
                struct DXRubyCollision o_collision, d_collision;
                float centerx, centery;

                if( o->rotation_flg || o->scaling_flg ) // o]Ă
                {
                    // o̎pɉ]
                    rotation_box( o, ox, oy );
                }
                else // o͉]ĂȂ
                {
                    ox[0] = ox[3] = o->x1;
                    oy[0] = oy[1] = o->y1;
                    ox[1] = ox[2] = o->x2;
                    oy[2] = oy[3] = o->y2;
                }

                // dS_
                centerx = d->center_x + d->base_x;
                centery = d->center_y + d->base_y;

                // dS_𒆐So]
                rotation_box_out( centerx, centery, -d->angle, ox, oy )

                // oE{[쐬
                volume_box( 4, ox, oy, &o_collision );

                // d̃XP[O
                scaling_box( d, dx, dy );

                // dE{[쐬
                volume_box( 4, dx, dy, &d_collision );

                if( !check_box_box( &o_collision, &d_collision ) )
                {
                    return FALSE; // ĂȂ
                }
            }
            return TRUE; // ɗ_œĂ
            break;
        case 3: // ~m
        {

//            if( (o->scale_x != o->scale_y && RTEST(o_sprite->vcollision_sync)) || // oȉ~
//                (d->scale_x != d->scale_y && RTEST(d_sprite->vcollision_sync)) )  // dȉ~
//            { /* ǂȉ~Ȃȉ~ł̏Փ˔ */
//                struct ELLIPSE e1, e2;
//                float ox, oy, or, dx, dy, dr;
//                if( RTEST(o_sprite->vcollision_sync) )
//                {
//                    rotation_point( o, ox, oy, NUM2FLOAT(RARRAY_PTR(o_sprite->vcollision)[0]), NUM2FLOAT(RARRAY_PTR(o_sprite->vcollision)[1]) );
//                }
//                else
//                {
//                    ox = o->base_x + NUM2FLOAT(RARRAY_PTR(o_sprite->vcollision)[0]);
//                    oy = o->base_y + NUM2FLOAT(RARRAY_PTR(o_sprite->vcollision)[1]);
//                }
//                or = NUM2FLOAT(RARRAY_PTR(o_sprite->vcollision)[2]);
//
//                e1.fCx = ox;
//                e1.fCy = oy;
//                if( RTEST(o_sprite->vcollision_sync) )
//                {
//                    e1.fRad_X = o->scale_x * or * 1;
//                    e1.fRad_Y = o->scale_y * or * 1;
//                    e1.fAngle = 3.141592653589793115997963468544185161590576171875f / 180.0f * o->angle;
//                }
//                else
//                {
//                    e1.fRad_X = or * 1;
//                    e1.fRad_Y = or * 1;
//                    e1.fAngle = 0;
//                }
//
//                if( RTEST(d_sprite->vcollision_sync) )
//                {
//                    rotation_point( d, dx, dy, NUM2FLOAT(RARRAY_PTR(d_sprite->vcollision)[0]), NUM2FLOAT(RARRAY_PTR(d_sprite->vcollision)[1]) );
//                }
//                else
//                {
//                    dx = d->base_x + NUM2FLOAT(RARRAY_PTR(d_sprite->vcollision)[0]);
//                    dy = d->base_y + NUM2FLOAT(RARRAY_PTR(d_sprite->vcollision)[1]);
//                }
//                dr = NUM2FLOAT(RARRAY_PTR(d_sprite->vcollision)[2]);
//
//                e2.fCx = dx;
//                e2.fCy = dy;
//                if( RTEST(d_sprite->vcollision_sync) )
//                {
//                    e2.fRad_X = d->scale_x * dr * 1;
//                    e2.fRad_Y = d->scale_y * dr * 1;
//                    e2.fAngle = 3.141592653589793115997963468544185161590576171875f / 180.0f * d->angle;
//                }
//                else
//                {
//                    e2.fRad_X = dr * 1;
//                    e2.fRad_Y = dr * 1;
//                    e2.fAngle = 0;
//                }
///*
//                printf("e1.fCx=%f\n", e1.fCx);
//                printf("e1.fCy=%f\n", e1.fCy);
//                printf("e1.fRad_X=%f\n", e1.fRad_X);
//                printf("e1.fRad_Y=%f\n", e1.fRad_Y);
//                printf("e1.fAngle=%f\n", e1.fAngle);
//                printf("e2.fCx=%f\n", e2.fCx);
//                printf("e2.fCy=%f\n", e2.fCy);
//                printf("e2.fRad_X=%f\n", e2.fRad_X);
//                printf("e2.fRad_Y=%f\n", e2.fRad_Y);
//                printf("e2.fAngle=%f\n", e2.fAngle);
//*/
//                
//                return CollisionEllipse( e1, e2 );
//            }
//            else
            { /* ^~m */
                float ox, oy, or, dx, dy, dr;

                if( o->rotation_flg ) /* o]Ă */
                {
                    float tempx = NUM2FLOAT(RARRAY_PTR(o_sprite->vcollision)[0]);
                    float tempy = NUM2FLOAT(RARRAY_PTR(o_sprite->vcollision)[1]);
                    rotation_point( o, ox, oy, tempx, tempy );
                }
                else
                {
                    ox = o->base_x + NUM2FLOAT(RARRAY_PTR(o_sprite->vcollision)[0]);
                    oy = o->base_y + NUM2FLOAT(RARRAY_PTR(o_sprite->vcollision)[1]);
                }
                or = NUM2FLOAT(RARRAY_PTR(o_sprite->vcollision)[2]);

                if( d->rotation_flg ) /* d]Ă */
                {
                    float tempx = NUM2FLOAT(RARRAY_PTR(d_sprite->vcollision)[0]);
                    float tempy = NUM2FLOAT(RARRAY_PTR(d_sprite->vcollision)[1]);
                    rotation_point( d, dx, dy, tempx, tempy );
                }
                else
                {
                    dx = d->base_x + NUM2FLOAT(RARRAY_PTR(d_sprite->vcollision)[0]);
                    dy = d->base_y + NUM2FLOAT(RARRAY_PTR(d_sprite->vcollision)[1]);
                }
                dr = NUM2FLOAT(RARRAY_PTR(d_sprite->vcollision)[2]);

                return check_circle_circle( ox, oy, or, dx, dy, dr );
            }
        }
            break;
        case 2: // _
            return TRUE; // ɗ_œĂ
            break;
        case 6: // Op
            return 0;
            break;
        default:
            rb_raise( eDXRubyError, "肦ȂG[" );
        }
    }
    else
    {// Ⴄ`̔r
        if( (o_type == 3 && d_type == 4) || (o_type == 4 && d_type == 3) ) // `Ɖ~
        {
            struct DXRubyCollision *circle_collision;
            struct DXRubySprite *circle_sprite;
            struct DXRubyCollision *box_collision;
            float box_x[4], box_y[4]; /* `W */
            float circle_x, circle_y, circle_r;
            float center_x, center_y;

            if( o_type == 3 )
            {
                circle_sprite = o_sprite;
                circle_collision = o;
                box_collision = d;
            }
            else
            {
                circle_sprite = d_sprite;
                circle_collision = d;
                box_collision = o;
            }

            if( !circle_collision->scaling_flg || circle_collision->scale_x == circle_collision->scale_y ) /* ~ό`ĂȂA͏c */
            {
                if( box_collision->scaling_flg ) /* `ό`Ă */
                {   /* ό` */
                    scaling_box( box_collision, box_x, box_y )
                }
                else
                {
                    box_x[0] = box_x[3] = box_collision->bx1 + box_collision->base_x;
                    box_y[0] = box_y[1] = box_collision->by1 + box_collision->base_y;
                    box_x[1] = box_x[2] = box_collision->bx2 + box_collision->base_x;
                    box_y[2] = box_y[3] = box_collision->by2 + box_collision->base_y;
                }

                if( circle_collision->rotation_flg || circle_collision->scaling_flg ) /* ~]Ă */
                {
                    float tempx = NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[0]);
                    float tempy = NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[1]);
                    /* ~̒Sx[Xŉ] */
                    rotation_point( circle_collision, circle_x, circle_y, tempx, tempy );
                }
                else
                {
                    circle_x = NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[0]) + circle_collision->base_x;
                    circle_y = NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[1]) + circle_collision->base_y;
                }

                if( box_collision->rotation_flg ) /* `]Ă */
                {   /* ~̒S_`Sx[Xŉ] */
                    rotation_point_out( box_collision->center_x + box_collision->base_x, box_collision->center_y + box_collision->base_y, -box_collision->angle, circle_x, circle_y );
                }

                circle_r = NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[2]) * circle_collision->scale_x;

                if( circle_x - circle_r < box_x[2] && circle_y - circle_r < box_y[2] && box_x[0] < circle_x + circle_r && box_y[0] < circle_y + circle_r )
                {
                    return 1;
                }

                /* Ƃ͉~Ɖ]ĂȂ`̔łB */
                return check_point_box(circle_x, circle_y, box_x[0] - circle_r, box_y[0], box_x[2] + circle_r, box_y[2]) ||
                       check_point_box(circle_x, circle_y, box_x[0], box_y[0] - circle_r, box_x[2], box_y[2] + circle_r) ||
                       check_circle_point(box_x[0], box_y[0], circle_r, circle_x, circle_y) ||
                       check_circle_point(box_x[1], box_y[1], circle_r, circle_x, circle_y) ||
                       check_circle_point(box_x[2], box_y[2], circle_r, circle_x, circle_y) ||
                       check_circle_point(box_x[3], box_y[3], circle_r, circle_x, circle_y);
            }

            if( box_collision->rotation_flg || box_collision->scaling_flg ) // `]Eό`Ă
            {
                /* `̎pɉ]Eό` */
                rotation_box( box_collision, box_x, box_y );
            }
            else /* `͉]Eό`ĂȂ */
            {
                box_x[0] = box_x[3] = box_collision->x1;
                box_y[0] = box_y[1] = box_collision->y1;
                box_x[1] = box_x[2] = box_collision->x2;
                box_y[2] = box_y[3] = box_collision->y2;
            }

            center_x = circle_collision->center_x + circle_collision->base_x;
            center_y = circle_collision->center_y + circle_collision->base_y;

            if( circle_collision->rotation_flg ) /* ~]Ă */
            {
                /* ~S_𒆐Sɋ`] */
                rotation_box_out( center_x, center_y, -circle_collision->angle, box_x, box_y )
            }
            circle_r = NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[2]);

            circle_x = circle_collision->base_x + NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[0]);
            circle_y = circle_collision->base_y + NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[1]);
            if( circle_collision->scaling_flg ) /* ~ό`Ă */
            {   /* ~^~ɂȂ悤ɋ`ό` */
                box_x[0] = (box_x[0] - center_x) / circle_collision->scale_x + center_x;
                box_y[0] = (box_y[0] - center_y) / circle_collision->scale_y + center_y;
                box_x[1] = (box_x[1] - center_x) / circle_collision->scale_x + center_x;
                box_y[1] = (box_y[1] - center_y) / circle_collision->scale_y + center_y;
                box_x[2] = (box_x[2] - center_x) / circle_collision->scale_x + center_x;
                box_y[2] = (box_y[2] - center_y) / circle_collision->scale_y + center_y;
                box_x[3] = (box_x[3] - center_x) / circle_collision->scale_x + center_x;
                box_y[3] = (box_y[3] - center_y) / circle_collision->scale_y + center_y;
            }

            /*  */
            return checktriangle(circle_x, circle_y, box_x[0], box_y[0], box_x[1], box_y[1], box_x[2], box_y[2]) || 
                   checktriangle(circle_x, circle_y, box_x[0], box_y[0], box_x[2], box_y[2], box_x[3], box_y[3]) || 
                   checkCircleLine(circle_x, circle_y, circle_r, box_x[0], box_y[0], box_x[1], box_y[1]) ||
                   checkCircleLine(circle_x, circle_y, circle_r, box_x[1], box_y[1], box_x[2], box_y[2]) ||
                   checkCircleLine(circle_x, circle_y, circle_r, box_x[2], box_y[2], box_x[3], box_y[3]) ||
                   checkCircleLine(circle_x, circle_y, circle_r, box_x[3], box_y[3], box_x[0], box_y[0]);
        }

        if( (o_type == 2 && d_type == 4) || (o_type == 4 && d_type == 2) ) // _Ƌ`
        {
            struct DXRubyCollision *point_collision;
            struct DXRubyCollision *box_collision;

            if( o_type == 2 )
            {
                point_collision = o;
                box_collision = d;
            }
            else
            {
                point_collision = d;
                box_collision = o;
            }

            if( box_collision->rotation_flg || box_collision->scaling_flg ) // `]Ă
            {// _`Sɉ]Ĕr
                float px[4], py[4];
                float bx[4], by[4];
                struct DXRubyCollision p_collision, b_collision;
                float centerx, centery;

                px[0] = px[3] = point_collision->x1;
                py[0] = py[1] = point_collision->y1;
                px[1] = px[2] = point_collision->x2;
                py[2] = py[3] = point_collision->y2;

                // `ό`S_
                centerx = box_collision->center_x + box_collision->base_x;
                centery = box_collision->center_y + box_collision->base_y;

                // `ό`S_𒆐Sɓ_]
                rotation_box_out( centerx, centery, -box_collision->angle, px, py )

                // _E{[쐬
                volume_box( 4, px, py, &p_collision );

                // `̊gEk
                scaling_box( box_collision, bx, by );

                // `E{[쐬
                volume_box( 4, bx, by, &b_collision );

                if( !check_box_box( &p_collision, &b_collision ) )
                {
                    return FALSE; // ĂȂ
                }
            }
            return TRUE; // ɗ_œĂ
        }

        if( (o_type == 2 && d_type == 3) || (o_type == 3 && d_type == 2) ) // _Ɖ~(b)
        {
            struct DXRubySprite *circle_sprite;
            struct DXRubyCollision *point_collision;
            struct DXRubyCollision *circle_collision;
            float cx, cy, cr;

            if( o_type == 3 )
            {
                circle_sprite = o_sprite;
                circle_collision = o;
                point_collision = d;
            }
            else
            {
                circle_sprite = d_sprite;
                circle_collision = d;
                point_collision = o;
            }

            if( circle_collision->rotation_flg ) /* ~]Ă */
            {
                float tempx = NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[0]);
                float tempy = NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[1]);
                rotation_point( circle_collision, cx, cy, tempx, tempy );
            }
            else
            {
                cx = circle_collision->base_x + NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[0]);
                cy = circle_collision->base_y + NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[1]);
            }
            cr = NUM2FLOAT(RARRAY_PTR(circle_sprite->vcollision)[2]);

            if( circle_collision->scaling_flg ) /* ~ό`Ă */
            {   /* ~^~ɂȂ悤ɓ_̍Wό` */
                float center_x, center_y;
                center_x = circle_collision->center_x + circle_collision->base_x;
                center_y = circle_collision->center_y + circle_collision->base_y;
                cx = (cx - center_x) / circle_collision->scale_x + center_x;
                cy = (cy - center_y) / circle_collision->scale_y + center_y;
            }

            return check_circle_point( cx, cy, cr, point_collision->x1 + 0.5, point_collision->y1 + 0.5 );
        }
        
        rb_raise( eDXRubyError, "肦ȂG[" );
        return 0;
    }

}


/* Փ˔pAABBE{[쐬 */
int make_volume( VALUE ary, struct DXRubyCollision *collision )
{
    int i, p, count = 0;

    for( p = 0; p < RARRAY_LEN(ary); p++)
    {
        struct DXRubySprite *sprite;
        if( TYPE( RARRAY_PTR(ary)[p] ) != T_DATA || RDATA(RARRAY_PTR(ary)[p])->dfree != (RUBY_DATA_FUNC)Sprite_release )
        {
//            collision->x1 = collision->y1 = collision->x2 = collision->y2 = 0.0f;
//            collision->vsprite = Qnil;
            continue;
        }
        sprite = DXRUBY_GET_STRUCT( Sprite, RARRAY_PTR(ary)[p] );
        if( !RTEST(sprite->vcollision_enable) )
        {
            continue;
        }

        collision->vsprite = RARRAY_PTR(ary)[p];
        collision->base_x = NUM2INT(sprite->vx);
        collision->base_y = NUM2INT(sprite->vy);
        collision->angle = NUM2FLOAT(sprite->vangle);
        collision->scale_x = NUM2FLOAT(sprite->vscale_x);
        collision->scale_y = NUM2FLOAT(sprite->vscale_y);
        if( RTEST(sprite->vcollision_sync) ) /* ]EXP[ÕtO */
        {
            if( collision->angle != 0.0f )
            {
                collision->rotation_flg = TRUE;
            }
            else
            {
                collision->rotation_flg = FALSE;
            }
            if( collision->scale_x != 1.0f || collision->scale_y != 1.0f )
            {
                collision->scaling_flg = TRUE;
            }
            else
            {
                collision->scaling_flg = FALSE;
            }
        }
        else
        {
                collision->rotation_flg = FALSE;
                collision->scaling_flg = FALSE;
        }

        if( sprite->vcollision != Qnil )
        {
            Check_Type( sprite->vcollision, T_ARRAY );

            switch RARRAY_LEN(sprite->vcollision)
            {
            case 2: /* _ */
                if( !collision->rotation_flg && !collision->scaling_flg )
                {
                    collision->bx1 = NUM2INT(RARRAY_PTR(sprite->vcollision)[0]);
                    collision->by1 = NUM2INT(RARRAY_PTR(sprite->vcollision)[1]);
                    collision->bx2 = NUM2INT(RARRAY_PTR(sprite->vcollision)[0]) + 1;
                    collision->by2 = NUM2INT(RARRAY_PTR(sprite->vcollision)[1]) + 1;
                    collision->x1 = collision->base_x + collision->bx1;
                    collision->y1 = collision->base_y + collision->by1;
                    collision->x2 = collision->base_x + collision->bx2;
                    collision->y2 = collision->base_y + collision->by2;
                }
                else /* ]_ */
                {
                    int tx,ty;
                    collision->bx1 = NUM2INT(RARRAY_PTR(sprite->vcollision)[0]);
                    collision->by1 = NUM2INT(RARRAY_PTR(sprite->vcollision)[1]);
                    collision->bx2 = NUM2INT(RARRAY_PTR(sprite->vcollision)[0]) + 1;
                    collision->by2 = NUM2INT(RARRAY_PTR(sprite->vcollision)[1]) + 1;

                    set_center( sprite, collision );
                    rotation_point( collision, tx, ty, collision->bx1 + 0.5f, collision->by1 + 0.5f );

                    collision->x1 = tx;
                    collision->y1 = ty;
                    collision->x2 = tx + 1;
                    collision->y2 = ty + 1;
                }
                break;
            case 3: /* ~ */
            {
                float tempx = NUM2FLOAT(RARRAY_PTR(sprite->vcollision)[0]);
                float tempy = NUM2FLOAT(RARRAY_PTR(sprite->vcollision)[1]);
                float tempr = NUM2FLOAT(RARRAY_PTR(sprite->vcollision)[2]);

                if( !collision->rotation_flg && !collision->scaling_flg )
                {
                    collision->x1 = collision->base_x + tempx - tempr;
                    collision->y1 = collision->base_y + tempy - tempr;
                    collision->x2 = collision->base_x + tempx + tempr;
                    collision->y2 = collision->base_y + tempy + tempr;
                }
                else /* ]~ */
                {
                    float tx,ty;

                    if( collision->scale_x != collision->scale_y ) /* ȉ~B̂ŎbƂċE{[]ċE{[ */
                    {
                        float x[4], y[4];
                        collision->bx1 = tempx - tempr;
                        collision->by1 = tempy - tempr;
                        collision->bx2 = tempx + tempr;
                        collision->by2 = tempy + tempr;

                        set_center( sprite, collision );

                        rotation_box( collision, x, y );
                        volume_box( 4, x, y, collision );
                    }
                    else /* ^~ */
                    {
                        set_center( sprite, collision );
                        rotation_point( collision, tx, ty, tempx, tempy );
                        collision->x1 = tx - tempr;
                        collision->y1 = ty - tempr;
                        collision->x2 = tx + tempr;
                        collision->y2 = ty + tempr;
                    }
                }
                break;
            }
            case 4: /* ` */
                if( !collision->rotation_flg && !collision->scaling_flg )
                {
                    collision->bx1 = NUM2INT(RARRAY_PTR(sprite->vcollision)[0]);
                    collision->by1 = NUM2INT(RARRAY_PTR(sprite->vcollision)[1]);
                    collision->bx2 = NUM2INT(RARRAY_PTR(sprite->vcollision)[2]) + 1;
                    collision->by2 = NUM2INT(RARRAY_PTR(sprite->vcollision)[3]) + 1;
                    collision->x1 = collision->base_x + collision->bx1;
                    collision->y1 = collision->base_y + collision->by1;
                    collision->x2 = collision->base_x + collision->bx2;
                    collision->y2 = collision->base_y + collision->by2;
                }
                else /* ]` */
                {
                    float tx[4], ty[4];

                    collision->bx1 = NUM2INT(RARRAY_PTR(sprite->vcollision)[0]);
                    collision->by1 = NUM2INT(RARRAY_PTR(sprite->vcollision)[1]);
                    collision->bx2 = NUM2INT(RARRAY_PTR(sprite->vcollision)[2]) + 1;
                    collision->by2 = NUM2INT(RARRAY_PTR(sprite->vcollision)[3]) + 1;
                    set_center( sprite, collision );

                    rotation_box( collision, tx, ty );

                    volume_box( 4, tx, ty, collision );
                }
                break;
            case 6: /* Op` */
            {
                float tx[3], ty[3];
                int i;
                if( !collision->rotation_flg && !collision->scaling_flg )
                {
                    tx[0] = collision->base_x + NUM2INT(RARRAY_PTR(sprite->vcollision)[0]) + 0.5f;
                    ty[0] = collision->base_y + NUM2INT(RARRAY_PTR(sprite->vcollision)[1]) + 0.5f;
                    tx[1] = collision->base_x + NUM2INT(RARRAY_PTR(sprite->vcollision)[2]) + 0.5f;
                    ty[1] = collision->base_y + NUM2INT(RARRAY_PTR(sprite->vcollision)[3]) + 0.5f;
                    tx[2] = collision->base_x + NUM2INT(RARRAY_PTR(sprite->vcollision)[4]) + 0.5f;
                    ty[2] = collision->base_y + NUM2INT(RARRAY_PTR(sprite->vcollision)[5]) + 0.5f;
                }
                else /* ]Op` */
                {
                    struct DXRubyImage *image;
                    float centerx, centery;

                    float x1 = NUM2INT(RARRAY_PTR(sprite->vcollision)[0]) + 0.5f;
                    float y1 = NUM2INT(RARRAY_PTR(sprite->vcollision)[1]) + 0.5f;
                    float x2 = NUM2INT(RARRAY_PTR(sprite->vcollision)[2]) + 0.5f;
                    float y2 = NUM2INT(RARRAY_PTR(sprite->vcollision)[3]) + 0.5f;
                    float x3 = NUM2INT(RARRAY_PTR(sprite->vcollision)[4]) + 0.5f;
                    float y3 = NUM2INT(RARRAY_PTR(sprite->vcollision)[5]) + 0.5f;

                    float angle = 3.141592653589793115997963468544185161590576171875f / 180.0f * NUM2FLOAT(sprite->vangle);
                    float sina = sin( angle );
                    float cosa = cos( angle );
                    float data1x = NUM2FLOAT(sprite->vscale_x) * cosa;
                    float data1y = NUM2FLOAT(sprite->vscale_y) * sina;
                    float data2x = NUM2FLOAT(sprite->vscale_x) * sina;
                    float data2y = NUM2FLOAT(sprite->vscale_y) * cosa;

                    DXRUBY_CHECK_IMAGE( sprite->vimage );
                    image = DXRUBY_GET_STRUCT( Image, sprite->vimage );

                    centerx = sprite->vcenter_x == Qnil ? image->width / 2 : NUM2FLOAT(sprite->vcenter_x);
                    centery = sprite->vcenter_y == Qnil ? image->width / 2 : NUM2FLOAT(sprite->vcenter_y);

                    tx[0] = (x1 - centerx) * data1x - (y1 - centery) * data1y + centerx;
                    ty[0] = (x1 - centerx) * data2x + (y1 - centery) * data2y + centery;
                    tx[1] = (x2 - centerx) * data1x - (y2 - centery) * data1y + centerx;
                    ty[1] = (x2 - centerx) * data2x + (y2 - centery) * data2y + centery;
                    tx[2] = (x3 - centerx) * data1x - (y3 - centery) * data1y + centerx;
                    ty[2] = (x3 - centerx) * data2x + (y3 - centery) * data2y + centery;
                }
                collision->x1 = collision->x2 = tx[2];
                collision->y1 = collision->y2 = ty[2];
                for( i = 0; i < 2; i++ )
                {
                    if( collision->x1 > tx[i] )
                    {
                        collision->x1 = tx[i];
                    }
                    if( collision->x2 < tx[i] )
                    {
                        collision->x2 = tx[i];
                    }
                    if( collision->y1 > ty[i] )
                    {
                        collision->y1 = ty[i];
                    }
                    if( collision->y2 < ty[i] )
                    {
                        collision->y2 = ty[i];
                    }
                }

                collision->x1 += collision->base_x;
                collision->y1 += collision->base_y;
                collision->x2 += collision->base_x;
                collision->y2 += collision->base_y;
                set_center( sprite, collision );
            }
                break;
            default:
                rb_raise( eDXRubyError, "collision̐ݒ肪sł - Sprite_make_volume" );
                break;
            }
        }
        else /* Փ˔͈͏ȗ͉摜TCY̋`Ƃ݂Ȃ */
        { /* ]ĂȂ` */
            struct DXRubyImage *image;
            DXRUBY_CHECK_IMAGE( sprite->vimage );
            image = DXRUBY_GET_STRUCT( Image, sprite->vimage );
            if( !collision->rotation_flg && !collision->scaling_flg )
            {
                collision->bx1 = 0;
                collision->by1 = 0;
                collision->bx2 = image->width;
                collision->by2 = image->height;
                collision->x1 = collision->base_x;
                collision->y1 = collision->base_y;
                collision->x2 = collision->base_x + image->width;
                collision->y2 = collision->base_y + image->height;
            }
            else /* ]` */
            {
                float tx[4], ty[4];

                collision->bx1 = 0;
                collision->by1 = 0;
                collision->bx2 = image->width;
                collision->by2 = image->height;
                collision->center_x = sprite->vcenter_x == Qnil ? image->width / 2 : NUM2FLOAT(sprite->vcenter_x);\
                collision->center_y = sprite->vcenter_y == Qnil ? image->height / 2 : NUM2FLOAT(sprite->vcenter_y);\

                rotation_box( collision, tx, ty );

                volume_box( 4, tx, ty, collision );
            }
        }
        count += 1;
        collision += 1;
    }
    return count;
}

