﻿#include "ComboboxDelegate.h"
#include <QComboBox>

using namespace stand::delegate;

ComboboxDelegate::ComboboxDelegate(const QStringList &sl, QObject *parent) :
    QItemDelegate(parent)
{
    _sl = sl;
}

QWidget *ComboboxDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    QComboBox *e = new QComboBox(parent);
    e->addItems(_sl);

    return e;
}

void ComboboxDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
    QString val = index.model()->data(index, Qt::EditRole).toString();

    QComboBox *e = static_cast<QComboBox *>(editor);
    int i;
    if((i = e->findText(val)) != -1)
    {
        e->setCurrentIndex(i);
    }
}

void ComboboxDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
{
    QComboBox *e = static_cast<QComboBox *>(editor);

    model->setData(index, e->currentText(), Qt::EditRole);
}

void ComboboxDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    editor->setGeometry(option.rect);
}
