#ifndef TRACKDELEGATE_H
#define TRACKDELEGATE_H

#include <QStyledItemDelegate>
#include <QUndoCommand>

class QUndoStack;

namespace stand
{
namespace model
{
class SequenceModel;
}
namespace delegate
{

class TrackDelegate : public QStyledItemDelegate
{
    Q_OBJECT
public:
    explicit TrackDelegate(QObject *parent);
    virtual ~TrackDelegate();

    virtual void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    virtual QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    virtual void setEditorData(QWidget *editor, const QModelIndex &index) const;
    virtual void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const;

signals:
    void lyricChanged(const QModelIndex &, QAbstractItemModel *) const;

public slots:

private:
};


}
}

#endif // TRACKDELEGATE_H
