#include "EditorWindow.h"
#include "ui_EditorWindow.h"

#include <QCloseEvent>
#include <QMessageBox>

#include "../configure.h"

using namespace stand::gui;

const QString EditorWindow::EditorName = EditorWindow::tr(stand::EditorName);

EditorWindow::EditorWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::EditorWindow)
{
    ui->setupUi(this);
    QActionGroup *g = new QActionGroup(this);

    g->addAction(ui->actionCursor);
    g->addAction(ui->actionPencil);
    g->addAction(ui->actionEraser);

    // ファイル基本操作
    connect(ui->actionNewFile, SIGNAL(triggered()), ui->Body, SLOT(newfile()));
    connect(ui->actionOpen, SIGNAL(triggered()), ui->Body, SLOT(open()));
    connect(ui->actionSave, SIGNAL(triggered()), ui->Body, SLOT(save()));
    connect(ui->actionSaveAs, SIGNAL(triggered()), ui->Body, SLOT(saveas()));
    connect(ui->actionExit, SIGNAL(triggered()), this, SLOT(close()));

    connect(ui->actionOpenVsq, SIGNAL(triggered()), ui->Body, SLOT(openVsqFile()));

    // 編集基本操作
    connect(ui->actionUndo, SIGNAL(triggered()), ui->Body, SLOT(undo()));
    connect(ui->actionRedo, SIGNAL(triggered()), ui->Body, SLOT(redo()));

    // インポート操作
    connect(ui->actionImportWave, SIGNAL(triggered()), ui->Body, SLOT(importRawWave()));

    _currentTitle = EditorName;
    setWindowTitle(EditorName);
}

EditorWindow::~EditorWindow()
{
    delete ui;
}

void EditorWindow::closeEvent(QCloseEvent *e)
{
    if(ui->Body->confirmClearCurrent())
    {
        e->accept();
    }
    else
    {
        e->ignore();
    }
}

void EditorWindow::fileChanged(const QString &name)
{
    _currentTitle = EditorName + " - " + name;
    setWindowTitle(_currentTitle);
}
