#ifndef MIDIEVENT_H
#define MIDIEVENT_H

namespace stand
{
namespace io
{
namespace midi
{

class MidiEvent
{
public:
    MidiEvent();
    virtual ~MidiEvent();

    virtual const char *set(const char *p, int tick);

    inline char type() const
    {
        return _type;
    }

    inline char data1() const
    {
        return _data1;
    }

    inline char data2() const
    {
        return _data2;
    }

    inline const int tick() const
    {
        return _tick;
    }

    inline void setTick(int tick)
    {
        if(tick < 0)
        {
            tick = 0;
        }
        _tick = tick;
    }

    inline int length() const
    {
        return _length;
    }

protected:
    int _tick;
    int _length;
    char _type;
    char _data1;
    char _data2;
};

}
}
}

#endif // MIDIEVENT_H
