﻿#include "CharacterSettings.h"

#include <QFile>
#include <QTextStream>
#include <QStringList>

using namespace stand::io::utau;

CharacterSettings::CharacterSettings()
{
    _isGood = false;
}

bool CharacterSettings::read(const QString &path, QTextCodec *codec)
{
    QFile file(path);
    _isGood = false;
    if(!file.exists())
    {
        return false;
    }
    if(!file.open(QIODevice::ReadOnly))
    {
        return false;
    }

    QTextStream stream(&file);
    stream.setCodec(codec);

    while(!stream.atEnd())
    {
        QStringList sl = stream.readLine().split("=", QString::SkipEmptyParts);
        if(sl.size() == 2)
        {
            if(sl.at(0) == "name")
            {
                _name = sl.at(1);
            }
            else if(sl.at(0) == "image")
            {
                _imagePath = sl.at(1);
            }
            else if(sl.at(0) == "sample")
            {
                _sample = sl.at(1);
            }
            else if(sl.at(0) == "web")
            {
                _web = sl.at(1);
            }
            else if(sl.at(0) == "author")
            {
                _author = sl.at(1);
            }
            else
            {
                qDebug("CharacterSettingss::read(%s); // unkown symbol", path.toUtf8().data());
                qDebug(" \"%s = %s\"", sl.at(0).toUtf8().data(), sl.at(1).toUtf8().data());
            }
        }
    }
    _isGood = true;
    return true;
}
