﻿#include "PrefixMap.h"
#include "Utility.h"

#include <QFile>
#include <QTextStream>
#include <QStringList>

using namespace stand::io::utau;
using namespace stand::utility;

PrefixMap::PrefixMap()
{
    _isGood = false;
}

bool PrefixMap::read(const QString &path, QTextCodec *codec)
{
    QFile file(path);
    _isGood = false;
    if(!file.exists())
    {
        qDebug("PrefixMap::read(%s); // File not found.", path.toUtf8().data());
        return false;
    }
    if(!file.open(QIODevice::ReadOnly))
    {
        qDebug("PrefixMap::read(%s); // File could not be opened.", path.toUtf8().data());
        return false;
    }
    QTextStream stream(&file);
    stream.setCodec(codec);

    while(!stream.atEnd())
    {
        QStringList sl = stream.readLine().split(QRegExp("[ \t]"), QString::SkipEmptyParts);
        if(sl.size() == 1)
        {
            sl.push_back("");
        }
        if(sl.size() != 2)
        {
            continue;
        }
        int no = NoteFromString(sl.at(0));
        if(no < 0 || no > 127)
        {
            continue;
        }
        _prefix[no] = sl.at(1);
        _noteNumber[sl.at(1)] = no;
    }
    _isGood = true;
    return true;
}

const QString &PrefixMap::at(int note) const
{
    note = std::max(std::min(127, note), 0);
    return _prefix[note];
}

QStringList PrefixMap::prefixList() const
{
    QStringList sl;
    sl.push_back("");
    for(int i = 0; i < 127; i++)
    {
        if(!sl.contains(_prefix[i]))
        {
            sl << _prefix[i];
        }
    }
    return sl;
}
