﻿#ifndef PHONEMEITEM_H
#define PHONEMEITEM_H

#include "TreeItem.h"

namespace stand
{
namespace model
{

class PhonemeItem : public TreeItem
{
public:
    explicit PhonemeItem(const QString &name, TreeItem *parent = 0);

    virtual int columnCount() const
    {
        return _NumProperties;
    }

    static int GetColumnForString(const QString &key);

protected:
    virtual void setUpDomElement(QDomDocument &doc, QDomElement &element);

public:
    enum PhonemeProperty
    {
        Alias = 0,
        FilePath,
        FileType,
        LeftBlank,
        Length,
        FixedLength,
        Overlap,
        Preutterance,
        Note
    };

    enum PhonemeType
    {
        RawWave = 0,
        RawWorld,
        MelCepstrumWorld,    /* This means connect library. */
        MelCepstrum
    };

    const static QString Attributes[];
private:
    const static int _NumProperties = 9;
};


}
}

#endif // PHONEMEITEM_H
