﻿#include "TreeItem.h"
#include "xml/TreeXmlFactory.h"

using namespace stand::model;

TreeItem::TreeItem(const QString &name, TreeItem *parent) :
    QObject(parent)
{
    setParent(parent);
    setFlags(Qt::ItemIsEditable | Qt::ItemIsEnabled | Qt::ItemIsSelectable);
    setName(name);
}

TreeItem::~TreeItem()
{
    qDeleteAll(_children);
}

QVariant TreeItem::data(int column, int role) const
{
    if(role == Qt::DisplayRole || Qt::EditRole)
    {
        return _data.value(column);
    }
    return QVariant();
}

void TreeItem::setData(int column, const QVariant &d, int role)
{
    if(role == Qt::DisplayRole || Qt::EditRole)
    {
        if(column < 0)
        {
            return;
        }
        if(column < _data.size())
        {
            _data[column] = d;
            return;
        }
        while(column >= _data.size())
        {
            _data.append(QVariant());
        }
        _data[column] = d;
    }
}

QDomElement TreeItem::domElement(QDomDocument &doc)
{
    QDomElement element = doc.createElement("null");
    setUpDomElement(doc, element);

    if(name() != QString::null)
    {
        element.setAttribute("name", name());
        element.setAttribute("edit_flags", flags());
    }

    for(int i = 0; i < _children.size(); i++)
    {
        element.appendChild(_children[i]->domElement(doc));
    }
    return element;
}

void TreeItem::setUpDomElement(QDomDocument &doc, QDomElement &element)
{
    element.setTagName("item");

    for(int i = 0; i < _data.size(); i++)
    {
        QDomElement param = doc.createElement("data");
        param.setAttribute("column", i);
        param.setAttribute("type", _data[i].type());
        QDomText value = doc.createTextNode(_data[i].toString());
        param.appendChild(value);
        element.appendChild(param);
    }
}

void TreeItem::setDomNode(QDomNode &node, const xml::TreeXmlFactory *factory)
{
    QDomElement e = node.toElement();
    setName(e.attribute("name"));
    setFlags((Qt::ItemFlags)e.attribute("edit_flags").toInt());
    QDomNodeList children = e.childNodes();
    for(int i = 0; i < children.size(); i++)
    {
        QDomElement e = children.at(i).toElement();
        TreeItem *child = factory->createItem(e, this);
        if(child)
        {
            appendChild(child);
        }
    }
}

TreeItem *TreeItem::findChildItem(const QString &key)
{
    for(int i = 0; i < _children.size(); i++)
    {
        if(_children[i]->name() == key)
        {
            return _children[i];
        }
    }
    return NULL;
}

