﻿#ifndef SEQUENCEXMLFACTORY_H
#define SEQUENCEXMLFACTORY_H

#include "TreeXmlFactory.h"

#include <QHash>

namespace stand
{
namespace model
{
namespace xml
{

class SequenceXmlFactory : public TreeXmlFactory
{
public:
    SequenceXmlFactory();

    virtual stand::model::TreeItem *createItem(const QDomElement &element, TreeItem *parent) const;

private:
    TreeItem *_createItem(const QDomElement &element, TreeItem *parent) const;
    TreeItem *_createControl(const QDomElement &element, TreeItem *parent) const;
    TreeItem *_createTrack(const QDomElement &element, TreeItem *parent) const;
    TreeItem *_createMeasure(const QDomElement &element, TreeItem *parent) const;
    TreeItem *_createEvent(const QDomElement &element, TreeItem *parent) const;

    QHash<QString, TreeItem* (SequenceXmlFactory::*)(const QDomElement &, TreeItem *) const> _factories;

};

}
}
}

#endif // SEQUENCEXMLFACTORY_H
