#ifndef EXPORTER_H
#define EXPORTER_H

#include <QVector>
#include <QString>
#include "Interpreter.h"

namespace stand
{
namespace sequence
{
namespace importer
{

class Exporter
{
public:
    virtual ~Exporter(){ }

    virtual void push(const QString &) =  0;
    void push(const QVector<Interpreter *> &l)
    {
        for(int i = 0; i < l.size(); i++)
        {
            QString line = l[i]->toString();
            push(line);
        }
    }

    virtual bool write(const QString &) = 0;
    virtual void clear(){ }
};

}
}
}

#endif // EXPORTER_H
