#ifndef ENVELOPE_H
#define ENVELOPE_H

namespace stand
{
namespace utility
{
namespace envelope
{

class Envelope
{
public:
    explicit Envelope(double *data = 0, int tLen = 0, double framePeriod = 0, bool autodelete = false);
    virtual ~Envelope();

    double *data() const;
    double framePeriod() const;
    double at(double ms) const;
    double at(int index) const;
    int tLen() const;
    double length() const;

    virtual bool write(const char *path) const;
    virtual bool read(const char *path);

    void set(double *data, int tLen, double framePeriod, bool autodelete = false);

    inline double &operator[](int index)
    {
        if(!_data)
        {
            return _defaultValue;
        }
        if(index < 0)
        {
            index = 0;
        }
        else if(index >= _tLen)
        {
            index = _tLen - 1;
        }
        return _data[index];
    }

private:
    void _destroy();
    double *_data;
    double _framePeriod;
    int _tLen;
    bool _autodelete;
    double _defaultValue;
};

}
}
}

#endif // ENVELOPE_H
