#ifndef CONTROLAREA_H
#define CONTROLAREA_H

#include "ViewArea.h"

class QUndoStack;

namespace stand
{
namespace model
{
class ControlItem;
class TrackItem;
class TreeItem;
}
namespace view
{

class ControlView;
class ViewSettings;
class FrameWidget;
class TrackView;

class ControlArea : public ViewArea
{
    Q_OBJECT
public:
    explicit ControlArea(TrackView *track, ViewSettings *s, stand::model::TrackItem *tracks, QWidget *parent = 0);
    virtual ~ControlArea();

    void setControls(const QList<model::TreeItem *> &items);
    void addControl(model::TreeItem *item);
    void setSettings(ViewSettings *s);
    void setTrackView(TrackView *track);

protected:
    void resizeEvent(QResizeEvent *e);

signals:

public slots:
    void resetAll();
    void releaseSetting();
    void controlChanged();
    void trackSizeChanged(int w, int h);

private:
    QList<ControlView *> _views;
    int _currentIndex;

    ViewSettings *_settings;
    bool _settingsIsDeletable;
    int _hscrW;
};

class FrameWidget : public QWidget
{
    Q_OBJECT
public:
    explicit FrameWidget(ViewSettings *s, QWidget *parent) :
        QWidget(parent)
    {
        _settings = NULL;
        setSettings(s);
    }
    void setSettings(ViewSettings *s);

protected:
    void paintEvent(QPaintEvent *e);
private:
    ViewSettings *_settings;
};
}
}

#endif // CONTROLAREA_H
