#ifndef CONTROLVIEW_H
#define CONTROLVIEW_H

#include <QWidget>
#include <QHash>
#include <QUndoCommand>

#include "ControlItem.h"

class QUndoStack;

namespace stand
{
namespace view
{

class ViewSettings;

class ControlView : public QWidget
{
    Q_OBJECT
public:
    explicit ControlView(model::TreeItem *item, ViewSettings *s, QWidget *parent);
    virtual ~ControlView();

    void setRange(double bottom, double top);

    virtual void paintEvent(QPaintEvent *e);
    void setSettings(ViewSettings *s);
    ViewSettings *settings()
    {
        return _settings;
    }

    double valueAt(int y) const;
    int yAt(double value) const;

    void setIsTop(bool f)
    {
        _isTop = f;
    }

protected:
    void mousePressEvent(QMouseEvent *e);
    void mouseMoveEvent(QMouseEvent *e);
    void mouseReleaseEvent(QMouseEvent *e);

signals:

public slots:
    void releaseSettings();
    void BarMoved(int oldX, int newX);
    void widthChanged(int w);

private:
    QHash<int, int> _dragPos;
    QPoint _prevClicked;
    int _dragBegin, _dragEnd;
    stand::model::ControlItem *_control;
    stand::model::TreeItem *_controlProperty;
    ViewSettings *_settings;
    bool _settingsIsDeletable;
    bool _isClicked;
    bool _isEditable;
    bool _isTop;

    double _bottom;
    double _top;

    class ControlCommand : public QUndoCommand
    {
    public:
        ControlCommand(QUndoCommand *parent = 0);

        void undo();
        void redo();

        stand::model::ControlItem *control;
        ControlView *view;
        QList<stand::utility::ControlPoint> oldP;
        QList<stand::utility::ControlPoint> newP;
    };
};

}
}

#endif // CONTROLVIEW_H
