﻿#include "SingerView.h"

#include "ViewSettings.h"

#include <QPaintEvent>
#include <QPainter>

using namespace stand::view;

SingerView::SingerView(ViewSettings *settings, QWidget *parent) :
    QWidget(parent)
{
    _settings = NULL;
    _settingsIsDeletable = false;
    setSettings(settings);
}

SingerView::~SingerView()
{
    if(_settingsIsDeletable)
    {
        delete _settings;
    }
}

void SingerView::releaseSettings()
{
    disconnect(this, SLOT(releaseSettings()));
    _settings = new ViewSettings(1, 16, 64, this);
    _settingsIsDeletable = true;
}

void SingerView::setSettings(ViewSettings *s)
{
    disconnect(this, SLOT(releaseSettings()));
    if(_settingsIsDeletable)
    {
        delete _settings;
    }
    _settings = s;
    if(s)
    {
        connect(_settings, SIGNAL(AboutToDelete()), this, SLOT(releaseSettings()));
        _settingsIsDeletable = false;
    }
    else
    {
        _settings = new ViewSettings(1, 16, 64, this);
        _settingsIsDeletable = true;
    }
    connect(_settings, SIGNAL(StateChanged()), this, SLOT(update()));
    update();
}


void SingerView::paintEvent(QPaintEvent *e)
{
    QPainter p(this);

    p.fillRect(rect(), QColor(96, 96, 96));
    QFont font(p.font());
    font.setPointSize(_settings->noteHeight() - 6);
    font.setBold(true);
    p.setFont(font);
    p.setPen(QColor(0, 192, 192));
    p.drawRect(rect().x() - 1, rect().y() -1, rect().width(), rect().height() + 1);
    p.setPen(QColor(0, 192, 192));
    for(int i = 1; i < 3; i++)
    {
        int y = i * _settings->noteHeight();
        p.drawLine(e->rect().x() + 1, y, e->rect().right() + 1, y);
    }

    p.setPen(QColor(0, 192, 192));
    p.drawText(QRect(1, 2 + 0 * _settings->noteHeight(), width() - 8, _settings->noteHeight() - 2), "Singer", Qt::AlignRight | Qt::AlignVCenter);
    p.drawText(QRect(1, 2 + 1 * _settings->noteHeight(), width() - 8, _settings->noteHeight() - 2), "Tempo", Qt::AlignRight | Qt::AlignVCenter);
    p.drawText(QRect(1, 2 + 2 * _settings->noteHeight(), width() - 8, _settings->noteHeight() - 2), "Beat", Qt::AlignRight | Qt::AlignVCenter);
}
