/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.cluster;

import info.dragonlady.cluster.AssertionService;
import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.ResourceUtils;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionServiceImpl
extends UnicastRemoteObject
implements AssertionService {
    private static final long serialVersionUID = 1069975851107064286L;

    public AssertionServiceImpl() throws RemoteException {
    }

    public AssertionServiceImpl(int port) throws RemoteException {
        super(port);
    }

    public AssertionServiceImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public synchronized void put(String handle, String assertion) throws RemoteException {
        try {
            AssertionManager am = AssertionManager.getInstance();
            am.put(ResourceUtils.toHexByteArray(handle), AssertionManager.toSAMLAssertion(assertion));
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6007"));
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6001");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }

    @Override
    public synchronized void remove(byte[] handle) throws RemoteException {
        try {
            AssertionManager.getInstance().remove(handle);
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6008"));
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6002");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }

    @Override
    public synchronized void remove(String id) throws RemoteException {
        try {
            AssertionManager.getInstance().remove(id);
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6009"));
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6003");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }

    @Override
    public synchronized Map<String, String> getAssertionMap() throws RemoteException {
        try {
            Map<String, String> map = AssertionManager.getInstance().getAssertionMap();
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6010"));
            return map;
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6004");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }

    @Override
    public synchronized Map<String, String> getHandleMap() throws RemoteException {
        try {
            Map<String, String> map = AssertionManager.getInstance().getHandleMap();
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6011"));
            return map;
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6005");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }

    @Override
    public synchronized void setMap(Map<String, String> assertionMap, Map<String, String> handleMap) throws RemoteException {
        try {
            AssertionManager.getInstance().setMap(assertionMap, handleMap);
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6012"));
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6006");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }
}

