/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.ConsumerResource;
import info.dragonlady.sso.Requester;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.SSOContext;
import info.dragonlady.sso.authority.AuthorityException;
import info.dragonlady.sso.authority.EnforcementException;
import info.dragonlady.sso.authority.PolicyEnforcementPoint;
import info.dragonlady.sso.authority.SAMLAuthorityProvider;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.AssertionParser;
import info.dragonlady.sso.util.ResourceParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLBrowserProfile;
import org.opensaml.SAMLBrowserProfileFactory;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionConsumer
implements PolicyEnforcementPoint {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private String resource = null;
    private String authId = null;
    private Map<String, List<String>> attributes = null;

    public AssertionConsumer(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.resource = request.getParameter("TARGET");
    }

    @Override
    public boolean isEnforceable() throws EnforcementException {
        try {
            String recipient = ConsumerResource.getConsumer(this.request.getServerName(), this.request.getContextPath().replace("/", ""));
            SAMLBrowserProfile profile = SAMLBrowserProfileFactory.getInstance();
            SAMLBrowserProfile.BrowserProfileRequest bpReq = profile.receive(this.request);
            SAMLBrowserProfile.BrowserProfileResponse bpRes = profile.receive(null, bpReq, recipient, SSOContext.getInstance().getReplayCache(), null, 1);
            boolean valid = false;
            if (bpRes != null && bpRes.response != null) {
                Iterator itr = bpRes.response.getAssertions();
                while (itr.hasNext()) {
                    SAMLAssertion assertion = (SAMLAssertion)itr.next();
                    AssertionParser parser = new AssertionParser(assertion);
                    if (!parser.containsAuthenticationStatement()) continue;
                    if (assertion.isSigned()) {
                        assertion.verify();
                    }
                    if (valid = this.verify(assertion, this.resource)) break;
                }
            }
            return valid;
        }
        catch (Exception e) {
            throw new EnforcementException(SSOMessageResource.getMessage("1301"), e);
        }
    }

    private boolean verify(SAMLAssertion assertion, String resource) throws SAMLException, AuthorityException, ResourceParseException, InstantiationException, IllegalAccessException, ClassNotFoundException, CloneNotSupportedException {
        SAMLRequest samlRequest = Requester.createAuthenticationRequest(null, null, new AssertionParser(assertion).getName(), "urn:oasis:names:tc:SAML:1.0:cm:bearer", assertion.toString(), "urn:ietf:rfc:3075");
        SAMLResponse samlResponse = SAMLAuthorityProvider.getAuthenticationAuthority().query(samlRequest);
        SAMLException status = samlResponse.getStatus();
        if (!status.getCodes().next().equals(SAMLException.SUCCESS)) {
            throw new AuthorityException(status.getMessage(), status.getException());
        }
        SAMLAssertion authAssertion = (SAMLAssertion)samlResponse.getAssertions().next();
        samlRequest = Requester.createAttributeRequest(authAssertion, SSOConfig.getSAMLAttributeList());
        samlResponse = SAMLAuthorityProvider.getAttributeAuthority().query(samlRequest);
        status = samlResponse.getStatus();
        if (!status.getCodes().next().equals(SAMLException.SUCCESS)) {
            throw new AuthorityException(status.getMessage(), status.getException());
        }
        SAMLAssertion attrAssertion = (SAMLAssertion)samlResponse.getAssertions().next();
        samlRequest = Requester.createAuthorizationDecisionRequest((SAMLAssertion)authAssertion.clone(), (SAMLAssertion)attrAssertion.clone(), new SAMLAction("urn:oasis:names:tc:SAML:1.0:action:ghpp", "GET"), resource);
        samlResponse = SAMLAuthorityProvider.getPolicyDecisionPoint().query(samlRequest);
        status = samlResponse.getStatus();
        if (!status.getCodes().next().equals(SAMLException.SUCCESS)) {
            throw new AuthorityException(status.getMessage(), status.getException());
        }
        AssertionParser parser = new AssertionParser((SAMLAssertion)samlResponse.getAssertions().next());
        this.authId = parser.getName();
        this.attributes = parser.getAttribute();
        return parser.isPermitted();
    }

    @Override
    public void enforce() throws EnforcementException {
        try {
            this.response.addCookie(new Cookie("jsessionid".toUpperCase(), this.request.getSession().getId()));
            this.response.sendRedirect(this.resource);
        }
        catch (Exception e) {
            throw new EnforcementException(SSOMessageResource.getMessage("1302"), e);
        }
    }

    public String getAuthId() {
        return this.authId;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }
}

