/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.AssertionNotFoundException;
import info.dragonlady.sso.SSOException;
import info.dragonlady.sso.authority.SAMLAuthorityProvider;
import info.dragonlady.sso.message.SSOMessageResource;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLBinding;
import org.opensaml.SAMLBindingFactory;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.artifact.SAMLArtifactType0001;

public class Responder {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;

    public Responder(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public void processRequest() throws SSOException {
        try {
            SAMLBinding binding = SAMLBindingFactory.getInstance((String)"urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
            SAMLRequest samlRequest = binding.receive((Object)this.request, 1);
            SAMLResponse samlResponse = null;
            SAMLException samlException = null;
            Iterator itr = samlRequest.getArtifacts();
            if (itr.hasNext()) {
                samlResponse = new SAMLResponse(samlRequest.getId(), null, null, null);
                while (itr.hasNext()) {
                    SAMLArtifactType0001 artifact = (SAMLArtifactType0001)itr.next();
                    try {
                        SAMLAssertion assertionOrg = AssertionManager.getInstance().get(artifact.getAssertionHandle());
                        if (assertionOrg == null) {
                            throw new AssertionNotFoundException(SSOMessageResource.getMessage("1101", new Object[]{artifact}));
                        }
                        SAMLAssertion assertion = (SAMLAssertion)assertionOrg.clone();
                        samlResponse.addAssertion(assertion);
                    }
                    catch (Exception e) {
                        samlException = new SAMLException(SAMLException.RESPONDER, SSOMessageResource.getMessage("1102"), e);
                        samlResponse.setStatus(samlException);
                        samlResponse.setAssertions(null);
                        break;
                    }
                }
                if (samlException == null) {
                    samlResponse.setStatus(new SAMLException(SAMLException.SUCCESS));
                }
            } else {
                try {
                    samlResponse = SAMLAuthorityProvider.getAuthority(samlRequest).query(samlRequest);
                    samlException = samlResponse.getStatus();
                }
                catch (Exception e) {
                    samlException = new SAMLException(SAMLException.RESPONDER, SSOMessageResource.getMessage("1102"), e);
                    samlResponse.setStatus(samlException);
                }
            }
            binding.respond((Object)this.response, samlResponse, samlException);
            this.response.setStatus(200);
            this.response.getOutputStream().close();
        }
        catch (Exception e) {
            throw new SSOException(SSOMessageResource.getMessage("1103"), e);
        }
    }
}

