/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.cluster.Friend;
import info.dragonlady.sso.util.ResourceParseException;
import info.dragonlady.sso.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOConfig {
    private static final String resourcePath = "resources/sso_config.xml";

    public static final String getProvider() throws ResourceParseException {
        String expression = "sso/provider";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getIssuer() throws ResourceParseException {
        String expression = "sso/issuer";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final List<String> getSAMLAttributeList() throws ResourceParseException {
        String expression = "sso/saml_attribute/name";
        NodeList nodeList = ResourceUtils.getNodeSet(resourcePath, expression);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < nodeList.getLength()) {
            list.add(ResourceUtils.getTextContent(nodeList.item(i)));
            ++i;
        }
        return list;
    }

    public static final Integer getAssertionLife() throws ResourceParseException {
        String expression = "sso/assertion_life";
        return new Integer(ResourceUtils.getString(resourcePath, expression));
    }

    public static final String getAuthenticationAuthorityClass() throws ResourceParseException {
        String expression = "sso/authority/authentication-class";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getAttributeAuthorityClass() throws ResourceParseException {
        String expression = "sso/authority/attribute-class";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getPolicyDecisionPointClass() throws ResourceParseException {
        String expression = "sso/authority/policy-decision-class";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getIDProviderClass() throws ResourceParseException {
        String expression = "sso/idprovider-class";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getKeyStorePath() throws ResourceParseException {
        String expression = "sso/signature/keystore/path";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getKeyStoreAlias() throws ResourceParseException {
        String expression = "sso/signature/keystore/alias";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getKeyStorePassword() throws ResourceParseException {
        String expression = "sso/signature/keystore/password";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getCertPath() throws ResourceParseException {
        String expression = "sso/signature/cert-path";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getLoginKey() throws ResourceParseException {
        String expression = "sso/login-key";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getRedirection() throws ResourceParseException {
        String expression = "sso/redirection";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getCooperationService() throws ResourceParseException {
        String expression = "sso/cooperation-service";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final boolean isClusterStandalone() throws ResourceParseException {
        String expression = "sso/cluster/@standalone";
        return Boolean.valueOf(ResourceUtils.getString(resourcePath, expression));
    }

    public static final Friend[] getFriends() throws ResourceParseException {
        String expression = "ssocluster/friends_ip";
        NodeList list = ResourceUtils.getNodeSet(resourcePath, expression);
        Friend[] friends = new Friend[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            NamedNodeMap paramMap = node.getAttributes();
            String host = paramMap.getNamedItem("host").getNodeValue();
            String port = paramMap.getNamedItem("port").getNodeValue();
            Friend friend = new Friend();
            friend.setHost(host);
            friend.setPort(port);
            friends[i] = friend;
            ++i;
        }
        return friends;
    }

    public static final String getServiceName(String ipAddress, String port, String serviceName) {
        StringBuffer name = new StringBuffer();
        name.append("//");
        name.append(ipAddress);
        name.append(":");
        name.append(port);
        name.append("/");
        name.append(serviceName);
        return name.toString();
    }
}

