/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.authority;

import info.dragonlady.sso.authority.AuthorityException;
import info.dragonlady.sso.authority.SAMLAuthority;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.AssertionGenerator;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthenticationQuery;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;

public abstract class AuthenticationAuthority
implements SAMLAuthority {
    public final SAMLResponse query(SAMLRequest request) throws AuthorityException {
        try {
            SAMLResponse response = new SAMLResponse(request.getId(), null, null, null);
            SAMLException samlException = null;
            String authId = null;
            String confirmationMethod = null;
            String confirmationData = null;
            String authMethod = null;
            try {
                SAMLAuthenticationQuery query = (SAMLAuthenticationQuery)request.getQuery();
                SAMLSubject subject = query.getSubject();
                authId = subject.getNameIdentifier().getName();
                confirmationMethod = subject.getConfirmationMethods().next().toString();
                confirmationData = subject.getConfirmationData().getTextContent();
                authMethod = query.getAuthMethod();
            }
            catch (Exception e) {
                samlException = new SAMLException(SAMLException.REQUESTER, SSOMessageResource.getMessage("2001"), e);
            }
            if (samlException == null) {
                try {
                    if (this.authenticate(authId, confirmationMethod, confirmationData, authMethod)) {
                        SAMLAssertion assertion = AssertionGenerator.generateAuthenticationAssertion(authId, confirmationMethod, authMethod);
                        response.addAssertion(assertion);
                        samlException = new SAMLException(SAMLException.SUCCESS);
                    } else {
                        samlException = new SAMLException(SAMLException.RESPONDER, SSOMessageResource.getMessage("2002"));
                    }
                }
                catch (Exception e) {
                    samlException = new SAMLException(SAMLException.RESPONDER, SSOMessageResource.getMessage("2003"), e);
                }
            }
            response.setStatus(samlException);
            return response;
        }
        catch (Exception e) {
            throw new AuthorityException(SSOMessageResource.getMessage("2004"), e);
        }
    }

    protected abstract boolean authenticate(String var1, String var2, String var3, String var4) throws AuthorityException;
}

