/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.servlet;

import info.dragonlady.cluster.UserServiceWrapper;
import info.dragonlady.sso.AssertionConsumer;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.authority.EnforcementException;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.servlet.SSOBaseServlet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AssertionConsumerServlet
extends SSOBaseServlet {
    private static final long serialVersionUID = -453213517162787294L;

    protected void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block7: {
            try {
                AssertionConsumer consumer = new AssertionConsumer(request, response);
                if (consumer.isEnforceable()) {
                    consumer.enforce();
                    String authId = consumer.getAuthId();
                    Map<String, List<String>> attributes = consumer.getAttributes();
                    HttpSession session = request.getSession();
                    session.setAttribute(SSOConfig.getLoginKey(), (Object)authId);
                    if (attributes != null) {
                        for (String key : attributes.keySet()) {
                            session.setAttribute(key, attributes.get(key));
                        }
                    }
                    LoginManager.getInstance().add(authId, session.getId());
                    if (!SSOConfig.isClusterStandalone()) {
                        UserServiceWrapper.add(authId, session.getId());
                    }
                    break block7;
                }
                throw new EnforcementException(SSOMessageResource.getMessage("5301"));
            }
            catch (EnforcementException e) {
                this.processException(SSOMessageResource.getMessage("5302"), e, response, 403);
            }
            catch (Exception e) {
                this.processException(SSOMessageResource.getMessage("5303"), e, response, 404);
            }
        }
    }
}

