/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.wsse;

import info.dragonlady.crypto.Crypto;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import org.apache.commons.codec.binary.Base64;

public class WsseCredential {
    public static final String WSSE_HEADER_NAME = "X-WSSE";
    public static final String WSSE_TOKEN_NAME = "UsernameToken";
    public static final String WSSE_TOKEN_USERNAME = "Username";
    public static final String WSSE_TOKEN_PASSWORD_DIGEST = "PasswordDigest";
    public static final String WSSE_TOKEN_CREATED = "Created";
    public static final String WSSE_TOKEN_NONCE = "Nonce";
    private String userName = null;
    private String passwordDigest = null;
    private String created = null;
    private String nonce = null;

    private WsseCredential() {
    }

    private WsseCredential(String userName, String passwordDigest, String created, String nonce) {
        this.userName = userName;
        this.passwordDigest = passwordDigest;
        this.created = created;
        this.nonce = nonce;
    }

    public String getCreated() {
        return this.created;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getPasswordDigest() {
        return this.passwordDigest;
    }

    public String getUserName() {
        return this.userName;
    }

    public static final WsseCredential generate(String userName, String password) throws NoSuchAlgorithmException {
        Calendar cal = Calendar.getInstance();
        String nonce = Crypto.md5(String.valueOf(cal.getTimeInMillis()));
        nonce = Crypto.sha1(nonce);
        String created = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(cal.getTime());
        String passwordDigest = Crypto.sha1(String.valueOf(nonce) + created + password);
        return new WsseCredential(userName, passwordDigest, created, nonce);
    }

    public static final WsseCredential parse(String credential) {
        WsseCredential wc = null;
        if (credential.startsWith(WSSE_TOKEN_NAME)) {
            wc = new WsseCredential();
            String tokenStr = credential.replaceAll(WSSE_TOKEN_NAME, "");
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            indexList.add(tokenStr.indexOf(WSSE_TOKEN_USERNAME));
            indexList.add(tokenStr.indexOf(WSSE_TOKEN_PASSWORD_DIGEST));
            indexList.add(tokenStr.indexOf(WSSE_TOKEN_CREATED));
            indexList.add(tokenStr.indexOf(WSSE_TOKEN_NONCE));
            Collections.sort(indexList);
            int i = 0;
            while (i < indexList.size()) {
                String token = null;
                token = i < indexList.size() - 1 ? tokenStr.substring((Integer)indexList.get(i), (Integer)indexList.get(i + 1)) : tokenStr.substring((Integer)indexList.get(i));
                if ((token = token.trim()).endsWith(",")) {
                    token = token.substring(0, token.length() - 1);
                }
                String[] set = token.split("=", 2);
                String key = set[0];
                String value = set[1].substring(1, set[1].length() - 1);
                if (key.equals(WSSE_TOKEN_USERNAME)) {
                    wc.userName = value;
                }
                if (key.equals(WSSE_TOKEN_PASSWORD_DIGEST)) {
                    wc.passwordDigest = Crypto.toHexString(Base64.decodeBase64((byte[])value.getBytes()));
                }
                if (key.equals(WSSE_TOKEN_CREATED)) {
                    wc.created = value;
                }
                if (key.equals(WSSE_TOKEN_NONCE)) {
                    wc.nonce = Crypto.toHexString(Base64.decodeBase64((byte[])value.getBytes()));
                }
                ++i;
            }
        }
        return wc;
    }

    public boolean validate(String userName, String password) throws NoSuchAlgorithmException {
        if (!userName.equals(this.userName)) {
            return false;
        }
        String hash = String.valueOf(this.nonce) + this.created + password;
        hash = Crypto.sha1(hash);
        return hash.equals(this.passwordDigest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UsernameToken ");
        sb.append("Username=\"" + this.userName + "\", ");
        sb.append("PasswordDigest=\"" + new String(Base64.encodeBase64((byte[])Crypto.toByteArray(this.passwordDigest))) + "\", ");
        sb.append("Created=\"" + this.created + "\", ");
        sb.append("Nonce=\"" + new String(Base64.encodeBase64((byte[])Crypto.toByteArray(this.nonce))) + "\"");
        return sb.toString();
    }
}

