/*
 * @(#)ArtifactReceiver.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.AssertionParser;
import info.dragonlady.sso.util.ResourceParseException;
import info.dragonlady.sso.util.ResourceUtils;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLBrowserProfile;
import org.opensaml.SAMLBrowserProfileFactory;
import org.opensaml.SAMLBrowserProfile.BrowserProfileRequest;
import org.opensaml.SAMLBrowserProfile.BrowserProfileResponse;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParseException;
import org.opensaml.artifact.ArtifactParserException;
import org.opensaml.artifact.SAMLArtifact;
import org.opensaml.artifact.SAMLArtifactType0001;


/**
 * \[XTCg烊_CNVꂽvNXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/04/13 14:38:14 $
 */
public class ArtifactReceiver {

	private HttpServletRequest request = null;

	private HttpServletResponse response = null;

	private String authId = null;

	private Map<String, List<String>> attributes = null;

	private long expirationTime = 0;

	private String targetUrl = null;

	/**
	 * RXgN^B
	 * 
	 * @param request vIuWFNg
	 * @param response IuWFNg
	 */
	public ArtifactReceiver(HttpServletRequest request, HttpServletResponse response) {
		super();
		this.request = request;
		this.response = response;
//		this.targetUrl = request.getParameter(SSOConstants.NAME_TARGET);
	}

	/**
	 * A[eBt@Nggpă\[XTCgŔF؍ς݂ǂׁAF؏͂B
	 * 
	 * @throws SSOException
	 */
	public void receive() throws SSOException {
		BrowserProfileResponse bpr = null;
		String artifact = null;
		try {
			SAMLBrowserProfile profile = SAMLBrowserProfileFactory.getInstance();
			BrowserProfileRequest bpReq = profile.receive(request);
			targetUrl = bpReq.TARGET;
			artifact = bpReq.SAMLArt != null && bpReq.SAMLArt.length > 0 ? bpReq.SAMLArt[0] : null;
			bpr = profile.receive(null, bpReq, null, SSOContext.getInstance().getReplayCache(), new Requester(getResponder(artifact)), 1);

			// AT[V
			if(bpr != null && bpr.response != null) {
				Iterator<SAMLAssertion> itr = bpr.response.getAssertions();
				while(itr.hasNext()) {
					SAMLAssertion assertion = itr.next();
					AssertionParser parser = new AssertionParser(assertion);
					if(parser.containsAuthenticationStatement()) {
						authId = parser.getName();
						expirationTime = assertion.getNotOnOrAfter().getTime();
					}
					if(parser.containsAttributeStatement()) {
						attributes = parser.getAttribute();
					}
				}
			}
		} catch(Exception e) {
			throw new SSOException(SSOMessageResource.getMessage("1201", new Object[]{targetUrl, artifact}), e);
		}
	}

	/**
	 * AT[V璊oFID擾B
	 * 
	 * @return String FID
	 */
	public String getAuthId() {
		return authId;
	}

	/**
	 * AT[V璊o擾B
	 * 
	 * @return Map<String, List<String>> 
	 */
	public Map<String, List<String>> getAttributes() {
		return attributes;
	}

	/**
	 * AT[Vɐݒ肳ĂL擾B
	 * 
	 * @return long L
	 */
	public long getExpirationTime() {
		return expirationTime;
	}

	/**
	 * ^[QbgURL擾B
	 * 
	 * @return String ^[QbgURL
	 */
	public String getTargetUrl() {
		return targetUrl;
	}

	/**
	 * vꂽ^[QbgURLփ_CNgB
	 * 
	 * @throws IOException
	 */
	public void redirectToTarget() throws IOException {
		response.sendRedirect(this.targetUrl);
	}

	private String getResponder(String artifactStr) throws ArtifactParseException, ArtifactParserException, ResourceParseException {
		String responder = null;
		Artifact artifact = SAMLArtifact.getTypeCode(artifactStr).getParser().parse(artifactStr);
		if(artifact instanceof SAMLArtifactType0001) {
			String srcId = ResourceUtils.toBase64String(((SAMLArtifactType0001)artifact).getSourceId());
			responder = ResponderResource.getResponder(srcId);
		}
		return responder;
	}

}
