/*
 * @(#)IDProviderFactory.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.util.ResourceParseException;

/**
 * IDǗCX^XNXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/05/01 21:12:46 $
 */
public class IDProviderFactory {

	/**
	 * ftHgIDǗCX^X擾B
	 * 
	 * @return IDProvider IDǗCX^X
	 * @throws ResourceParseException
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws ClassNotFoundException
	 */
	public static final IDProvider getIDProvider() throws ResourceParseException, InstantiationException, IllegalAccessException, ClassNotFoundException {
		return getIDProvider(SSOConfig.getIDProviderClass());
	}

	/**
	 * w肳ꂽNXIDǗCX^X擾B
	 * 
	 * @param className IDǗNX
	 * @return IDProvider IDǗCX^X
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws ClassNotFoundException
	 */
	public static final IDProvider getIDProvider(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
		return (IDProvider)Class.forName(className).newInstance();
	}

}
