/*
 * @(#)Responder.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.AssertionNotFoundException;
import info.dragonlady.sso.authority.SAMLAuthorityProvider;
import info.dragonlady.sso.message.SSOMessageResource;

import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLBinding;
import org.opensaml.SAMLBindingFactory;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.artifact.SAMLArtifactType0001;


/**
 * SAMLsNX
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/04/13 22:50:33 $
 */
public class Responder {

	private HttpServletRequest request = null;

	private HttpServletResponse response = null;

	/**
	 * RXgN^
	 * 
	 * @param request vIuWFNg
	 * @param response IuWFNg
	 */
	public Responder(HttpServletRequest request, HttpServletResponse response) {
		super();
		this.request = request;
		this.response = response;
	}

	/**
	 * SAMLvA[eBt@Ng擾AA[eBt@NgɑΉAT[VSAMLԂ
	 * 
	 * @throws SSOException
	 */
	public void processRequest() throws SSOException {
		try {
			SAMLBinding binding = SAMLBindingFactory.getInstance(SAMLBinding.SOAP);
			SAMLRequest samlRequest = binding.receive(request, 1);
			SAMLResponse samlResponse = null;
			SAMLException samlException = null;

			Iterator<SAMLArtifactType0001> itr = samlRequest.getArtifacts();
			if(itr.hasNext()) {
				// SAMLvɃA[eBt@Ng܂܂ꍇ
				samlResponse = new SAMLResponse(samlRequest.getId(), null, null, null);
				while(itr.hasNext()) {
					SAMLArtifactType0001 artifact = itr.next();
					try {
						SAMLAssertion assertionOrg = AssertionManager.getInstance().get(artifact.getAssertionHandle());
						if(assertionOrg == null) {
							// A[eBt@NgɑΉAT[VȂ
							throw new AssertionNotFoundException(SSOMessageResource.getMessage("1101", new Object[]{artifact}));
						}
						// AT[V͎g񂷂̂ŁAN[쐬
						SAMLAssertion assertion = (SAMLAssertion)assertionOrg.clone();
	
						samlResponse.addAssertion(assertion);
					} catch(Exception e) {
						samlException = new SAMLException(SAMLException.RESPONDER, SSOMessageResource.getMessage("1102"), e);
						samlResponse.setStatus(samlException);
						samlResponse.setAssertions(null);
						break;
					}
				}
				if(samlException == null) {
					samlResponse.setStatus(new SAMLException(SAMLException.SUCCESS));
				}
			} else {
				// SAMLAuthority ɖ₢킹
				try {
					samlResponse = SAMLAuthorityProvider.getAuthority(samlRequest).query(samlRequest);
					samlException = samlResponse.getStatus();
				} catch(Exception e) {
					samlException = new SAMLException(SAMLException.RESPONDER, SSOMessageResource.getMessage("1102"), e);
					samlResponse.setStatus(samlException);
				}
			}

			// SAMLM
			binding.respond(response, samlResponse, samlException);
			response.setStatus(HttpServletResponse.SC_OK);
			response.getOutputStream().close();
		} catch(Exception e) {
			throw new SSOException(SSOMessageResource.getMessage("1103"), e);
		}
	}

}
