/*
 * @(#)LoginManager.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * OCǗNXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/09/27 19:18:36 $
 */
public class LoginManager {

	private static final LoginManager lm = new LoginManager();

	private volatile Map<String, String> userMap = Collections.synchronizedMap(new HashMap<String, String>());

	/**
	 * RXgN^B
	 */
	private LoginManager() {
		super();
	}

	/**
	 * CX^X擾B
	 * 
	 * @return LoginManager CX^X
	 */
	public static final LoginManager getInstance() {
		return lm;
	}

	/**
	 * [UǉB
	 * 
	 * @param user [U
	 * @param relationId ֘AID
	 */
	public synchronized void add(String user, String relationId) {
		if(!userMap.containsKey(user)) {
			userMap.put(user, relationId);
		}
	}

	/**
	 * [U폜B
	 * 
	 * @param user [U
	 */
	public synchronized void remove(String user) {
		userMap.remove(user);
	}

	/**
	 * [U폜B
	 * 
	 * @param relationId ֘AID
	 */
	public synchronized void removeById(String relationId) {
		userMap.values().remove(relationId);
	}

	/**
	 * w肳ꂽ[ŨOCԂ𒲂ׂB
	 * 
	 * @param user [U
	 * @return boolean trueFOCԁ^falseFOAEg
	 */
	public synchronized boolean isLoggedIn(String user) {
		return userMap.containsKey(user);
	}

	/**
	 * [UǗ}bv擾B
	 * 
	 * @return Map<String, String> [UǗ}bv
	 */
	public synchronized Map<String, String> getMap() {
		return Collections.unmodifiableMap(userMap);
	}

	/**
	 * [UǗ}bvݒ肷B
	 * 
	 * @param map [UǗ}bv
	 */
	public synchronized void setMap(Map<String, String> map) {
		clear();
		userMap.putAll(map);
	}

	/**
	 * [UǗB
	 * 
	 * @param map [UǗ}bv
	 */
	public synchronized void clear() {
		userMap.clear();
	}

}
