/*
 * @(#)MessageResource.java
 *
 * Copyright (C) 2005 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.message;

import jp.co.infocity.i18n.MessageResourceBundle;
import jp.co.infocity.i18n.ResourceBundleEx;

/**
 * bZ[W\[XNX
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.1 $ $Date: 2005/10/31 05:21:08 $
 */
public class MessageResource {

	/**
	 * bZ[W\[Xoh
	 */
	private MessageResourceBundle msb = null;

	/**
	 * RXgN^
	 */
	public MessageResource(String resource) {
		msb = new MessageResourceBundle(ResourceBundleEx.getBundle(resource));
	}

	/**
	 * \[X烁bZ[W擾
	 * 
	 * @param key bZ[W擾L[
	 * @return String bZ[W
	 */
	public String getMessage(String key) {
		String msg = "";
		if(msb != null) {
			msg = msb.getString(key);
		}
		return msg;
	}

	/**
	 * \[X烁bZ[W擾
	 * 
	 * @param key bZ[W擾L[
	 * @param args bZ[WtH[}bgp̃p[^
	 * @return String bZ[W
	 */
	public String getMessage(String key, Object[] args) {
		String msg = "";
		if(msb != null) {
			msg = msb.getString(key, args);
		}
		return msg;
	}

}
