/*
 * @(#)SSOMessageResourceTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.message;

import info.dragonlady.sso.message.SSOMessageResource;
import junit.framework.TestCase;

/**
 * SSOMessageResourceNX̃eXgP[X
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/10/19 16:54:54 $
 */
public class SSOMessageResourceTest extends TestCase {

	/**
	 * Constructor for SSOMessageResourceTest.
	 * @param arg0
	 */
	public SSOMessageResourceTest(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * 'info.dragonlady.sso.message.SSOMessageResource.getMessage(String)' ̂߂̃eXgE\bh
	 */
	public final void testGetMessageString() {
		try {
			String key = "1004";
			String expected = "SAMLւ̃AT[VǉɃG[܂B";

			String result = SSOMessageResource.getMessage(key);
			assertTrue(expected.equals(result));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * 'info.dragonlady.sso.message.SSOMessageResource.getMessage(String, Object[])' ̂߂̃eXgE\bh
	 */
	public final void testGetMessageStringObjectArray() {
		try {
			String key = "1003";
			Object[] args = {"param1"};
			String expected = "A[eBt@NgɑΉAT[V܂łBartifact:param1";

			String result = SSOMessageResource.getMessage(key, args);
			assertTrue(expected.equals(result));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
