/*
 * @(#)ArtifactResponderServletTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.servlet;

import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.servlet.ArtifactResponderServlet;

import java.io.InputStream;

import org.apache.cactus.ServletTestCase;
import org.apache.cactus.WebRequest;
import org.apache.cactus.WebResponse;


/**
 * ArtifactResponderServlet NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/11 16:02:02 $
 */
public class ArtifactResponderServletTest extends ServletTestCase {

	private String userId = "testuser";

	/**
	 * @param arg0
	 */
	public ArtifactResponderServletTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.servlet.ArtifactResponderServlet#ArtifactResponderServlet()} ̂߂̃eXgE\bhB
	 */
	public final void testArtifactResponderServlet() {
		try {
			new ArtifactResponderServlet();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * @param theRequest
	 */
	public final void beginServiceHttpServletRequestHttpServletResponse(WebRequest theRequest) {
		try {
			theRequest.addParameter("id", userId, WebRequest.GET_METHOD);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * F؍ς
	 * 
	 * {@link info.dragonlady.sso.servlet.ArtifactResponderServlet#service(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)} ̂߂̃eXgE\bhB
	 */
	public final void testServiceHttpServletRequestHttpServletResponse() {
		try {
			session.setAttribute(SSOConfig.getLoginKey(), userId);

			ArtifactResponderServlet servlet = new ArtifactResponderServlet();
			config.setInitParameter("auth-class", "info.dragonlady.sso.helper.SessionAuthenticator");
			servlet.init(config);
			servlet.service(request, response);

			session.removeAttribute(SSOConfig.getLoginKey());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * @param theResponse
	 */
	public final void endServiceHttpServletRequestHttpServletResponse(WebResponse theResponse) {
		InputStream is = null;
		try {
			String artifact = null;
			assertTrue(theResponse.getStatusCode() == 200);
			is = theResponse.getInputStream();
			try {
				byte[] b = new byte[is.available()];
				is.read(b);
				artifact = new String(b);
			} catch(Exception e) {
				assertTrue(e.toString(), false);
			}
			assertTrue(artifact != null && artifact.length() > 0);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		} finally {
			if(is != null) {
				try {
					is.close();
				} catch(Exception e) {
				}
			}
		}
	}

	/**
	 * @param theRequest
	 */
	public final void beginServiceHttpServletRequestHttpServletResponse2(WebRequest theRequest) {
		try {
			theRequest.addParameter("id", userId, WebRequest.GET_METHOD);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * F
	 * 
	 * {@link info.dragonlady.sso.servlet.ArtifactResponderServlet#service(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)} ̂߂̃eXgE\bhB
	 */
	public final void testServiceHttpServletRequestHttpServletResponse2() {
		try {
			session.removeAttribute(SSOConfig.getLoginKey());

			ArtifactResponderServlet servlet = new ArtifactResponderServlet();
			config.setInitParameter("auth-class", "info.dragonlady.sso.helper.SessionAuthenticator");
			servlet.init(config);
			servlet.service(request, response);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * @param theResponse
	 */
	public final void endServiceHttpServletRequestHttpServletResponse2(WebResponse theResponse) {
		InputStream is = null;
		try {
			String artifact = null;
			assertTrue(theResponse.getStatusCode() == 200);
			is = theResponse.getInputStream();
			try {
				byte[] b = new byte[is.available()];
				is.read(b);
				artifact = new String(b);
			} catch(Exception e) {
				assertTrue(e.toString(), false);
			}
			assertTrue(artifact != null && artifact.length() == 0);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		} finally {
			if(is != null) {
				try {
					is.close();
				} catch(Exception e) {
				}
			}
		}
	}

}
