/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.RequestFailedException;
import info.dragonlady.sso.ResponderResource;
import info.dragonlady.sso.util.ResourceUtils;
import java.util.Iterator;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthenticationQuery;
import org.opensaml.SAMLBinding;
import org.opensaml.SAMLBindingFactory;
import org.opensaml.SAMLIdentifierFactory;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.SAMLArtifactType0001;

public class Requester {
    public SAMLAssertion fetchAttribute(String artifactStr, String sessionId) throws RequestFailedException {
        try {
            SAMLRequest request = new SAMLRequest();
            SAMLAuthenticationQuery query = new SAMLAuthenticationQuery();
            request.setQuery((SAMLQuery)query);
            String requestId = "_" + ResourceUtils.toHexString(SAMLIdentifierFactory.getInstance().generateRandomBytes(20));
            request.setId(requestId);
            SAMLArtifactType0001 artifact = (SAMLArtifactType0001)new SAMLArtifactType0001.Parser().parse(artifactStr);
            request.addArtifact((Artifact)artifact);
            String srcId = ResourceUtils.toBase64String(artifact.getSourceId());
            String responder = String.valueOf(ResponderResource.getResponder(srcId)) + ";" + "jsessionid" + "=" + sessionId;
            SAMLBinding binding = SAMLBindingFactory.getInstance((String)"urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
            SAMLResponse response = binding.send(responder, request);
            Iterator itr = response.getAssertions();
            SAMLAssertion assertion = null;
            if (itr.hasNext()) {
                assertion = (SAMLAssertion)itr.next();
            }
            return assertion;
        }
        catch (Exception e) {
            throw new RequestFailedException(e);
        }
    }
}

