/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.deployable;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.module.application.ApplicationXml;
import org.codehaus.cargo.module.application.DefaultEarArchive;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public class EAR
extends MonitoredObject
implements Deployable {
    private File ear;
    private String name;
    private Map webapps;

    public EAR(String ear) {
        this.ear = new File(ear);
    }

    private void parseName() {
        if (this.name == null) {
            String name = this.getFile().getName();
            int nameIndex = name.toLowerCase().lastIndexOf(".ear");
            if (nameIndex >= 0) {
                name = name.substring(0, nameIndex);
            }
            this.getMonitor().debug("Parsed EAR name = [" + name + "]", this.getClass().getName());
            this.setName(name);
        }
    }

    private void parseWebApps() {
        if (this.webapps == null) {
            HashMap<String, String> webapps = new HashMap<String, String>();
            try {
                DefaultEarArchive ear = new DefaultEarArchive(this.getFile());
                ApplicationXml applicationXml = ear.getApplicationXml();
                Iterator it = applicationXml.getWebModuleUris();
                while (it.hasNext()) {
                    String webUri = (String)it.next();
                    String context = applicationXml.getWebModuleContextRoot(webUri);
                    if (context == null) {
                        throw new ContainerException("Your application.xml must define a <context-root> element in the <web> module definition.");
                    }
                    if (context.startsWith("/")) {
                        context = context.substring(1);
                    }
                    this.getMonitor().debug("Found Web URI [" + webUri + "], context [" + context + "]", this.getClass().getName());
                    webapps.put(context, webUri);
                }
            }
            catch (Exception e) {
                throw new ContainerException("Failed to parse webapps from [" + this.getFile() + "] EAR.", e);
            }
            this.webapps = webapps;
        }
    }

    public File getFile() {
        return this.ear;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized String getName() {
        this.parseName();
        return this.name;
    }

    public synchronized Iterator getWebContexts() {
        this.parseWebApps();
        return this.webapps.keySet().iterator();
    }

    public synchronized String getWebUri(String context) {
        this.parseWebApps();
        return (String)this.webapps.get(context);
    }
}

