/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jo;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Iterator;
import org.apache.tools.ant.filters.ReplaceTokens;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.jo.Jo1xStandaloneConfigurationCapability;
import org.codehaus.cargo.container.spi.AbstractStandaloneConfiguration;

public class Jo1xStandaloneConfiguration
extends AbstractStandaloneConfiguration {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String TOKEN_KEY_WAR_DIR = "jo.wardir";
    private static final String TOKEN_KEY_WEBAPP = "jo.webapp";
    private static final String TOKEN_KEY_LOGLEVEL = "jo.loglevel";
    private static final String DEFAULT_HOSTNAME = "*";
    private static final String DEFAULT_PORT = "8080";
    private static final String DEFAULT_LOGLEVEL = "medium";
    private static final String DEFAULT_METASERVER_PORT = "9090";
    private ConfigurationCapability capability = new Jo1xStandaloneConfigurationCapability();

    public Jo1xStandaloneConfiguration(Container container) {
        super(container);
    }

    public Jo1xStandaloneConfiguration(Container container, File configDir) {
        super(container, configDir);
    }

    public ConfigurationCapability getCapability() {
        return this.capability;
    }

    public void configure() {
        try {
            this.createConfigurationDir();
            FilterChain filterChain = this.createJoFilterChain();
            File confDir = this.getFileUtils().createDirectory(this.getDir(), "etc");
            String resourcePath = "/org/codehaus/cargo/container/internal/resources/jo1x";
            this.getResourceUtils().copyResource(resourcePath + "/factory.properties", new File(confDir, "factory.properties"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/groups.properties", new File(confDir, "groups.properties"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/hosts.properties", new File(confDir, "hosts.properties"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/listener.properties", new File(confDir, "listener.properties"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/mime.properties", new File(confDir, "mime.properties"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/roles.properties", new File(confDir, "roles.properties"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/server.properties", new File(confDir, "server.properties"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/users.properties", new File(confDir, "users.properties"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/metaserver.properties", new File(confDir, "metaserver.properties"), filterChain);
            this.getResourceUtils().copyResource(resourcePath + "/metalistener.properties", new File(confDir, "metalistener.properties"), filterChain);
            this.getFileUtils().createDirectory(this.getDir(), "log");
            new File(this.getDir(), "webapp/host/").mkdirs();
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(this.getDir(), "webapp/host/cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create an " + this.getContainer().getName() + " container configuration", e);
        }
    }

    private FilterChain createJoFilterChain() throws MalformedURLException {
        FilterChain filterChain = this.createFilterChain();
        filterChain.addReplaceTokens(this.createWebappToken());
        filterChain.addReplaceTokens(this.createHostnameToken());
        filterChain.addReplaceTokens(this.createPortToken());
        filterChain.addReplaceTokens(this.createLogLevelToken());
        filterChain.addReplaceTokens(this.createMetaserverPortToken());
        filterChain.addReplaceTokens(this.createWarDirToken());
        return filterChain;
    }

    private ReplaceTokens createWebappToken() throws MalformedURLException {
        ReplaceTokens.Token tokenWebApps = new ReplaceTokens.Token();
        tokenWebApps.setKey(TOKEN_KEY_WEBAPP);
        StringBuffer keyWebApps = new StringBuffer();
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (!(deployable instanceof WAR)) continue;
            WAR war = (WAR)deployable;
            String webappName = war.getContext().replace('.', '_').replace('=', '_');
            String mapping = war.getContext();
            if (mapping == null) {
                mapping = "";
            } else if ("/".equals(mapping)) {
                mapping = "";
            } else if (!mapping.startsWith("/") && mapping.length() > 1) {
                mapping = "/" + mapping;
            }
            String docbase = war.getFile().getAbsoluteFile().toURL().toString();
            if (war.isExpandedWar()) {
                docbase = docbase + "/";
            }
            keyWebApps.append("# CARGO! Context: " + war.getContext() + " File: " + war.getFile() + LINE_SEPARATOR);
            keyWebApps.append("host.webapp." + webappName + ".mapping=" + mapping + LINE_SEPARATOR);
            keyWebApps.append("host.webapp." + webappName + ".docbase=" + docbase + LINE_SEPARATOR);
            keyWebApps.append(LINE_SEPARATOR);
        }
        if (keyWebApps.length() == 0) {
            keyWebApps.append(" ");
        }
        tokenWebApps.setValue(keyWebApps.toString());
        ReplaceTokens replaceWebApps = new ReplaceTokens();
        replaceWebApps.addConfiguredToken(tokenWebApps);
        return replaceWebApps;
    }

    private ReplaceTokens createHostnameToken() {
        ReplaceTokens.Token tokenHostname = new ReplaceTokens.Token();
        tokenHostname.setKey("cargo.hostname");
        String hostname = this.getPropertyValue("cargo.hostname");
        if (hostname == null) {
            hostname = DEFAULT_HOSTNAME;
        }
        tokenHostname.setValue(hostname);
        ReplaceTokens replaceHostname = new ReplaceTokens();
        replaceHostname.addConfiguredToken(tokenHostname);
        return replaceHostname;
    }

    private ReplaceTokens createPortToken() {
        ReplaceTokens.Token tokenPort = new ReplaceTokens.Token();
        tokenPort.setKey("cargo.servlet.port");
        String port = this.getPropertyValue("cargo.servlet.port");
        if (port == null) {
            port = DEFAULT_PORT;
        }
        tokenPort.setValue(port);
        ReplaceTokens replacePort = new ReplaceTokens();
        replacePort.addConfiguredToken(tokenPort);
        return replacePort;
    }

    private ReplaceTokens createLogLevelToken() {
        ReplaceTokens.Token tokenLogLevel = new ReplaceTokens.Token();
        tokenLogLevel.setKey(TOKEN_KEY_LOGLEVEL);
        String logLevel = this.getPropertyValue("cargo.logging");
        logLevel = logLevel == null ? DEFAULT_LOGLEVEL : logLevel.toLowerCase();
        String joLogLevel = "low".equals(logLevel) ? "1" : (DEFAULT_LOGLEVEL.equals(logLevel) ? "2" : ("high".equals(logLevel) ? "5" : "2"));
        tokenLogLevel.setValue(joLogLevel);
        ReplaceTokens replacePort = new ReplaceTokens();
        replacePort.addConfiguredToken(tokenLogLevel);
        return replacePort;
    }

    private ReplaceTokens createWarDirToken() {
        ReplaceTokens.Token tokenWarDir = new ReplaceTokens.Token();
        tokenWarDir.setKey(TOKEN_KEY_WAR_DIR);
        tokenWarDir.setValue(new File(this.getDir(), "webapp/host").toString());
        ReplaceTokens replaceWarDir = new ReplaceTokens();
        replaceWarDir.addConfiguredToken(tokenWarDir);
        return replaceWarDir;
    }

    private ReplaceTokens createMetaserverPortToken() {
        ReplaceTokens.Token tokenPort = new ReplaceTokens.Token();
        tokenPort.setKey("cargo.jo.metaserver.port");
        String port = this.getPropertyValue("cargo.jo.metaserver.port");
        if (port == null) {
            port = DEFAULT_METASERVER_PORT;
        }
        tokenPort.setValue(port);
        ReplaceTokens replacePort = new ReplaceTokens();
        replacePort.addConfiguredToken(tokenPort);
        return replacePort;
    }
}

