/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.container.deployable.DeployableFactory;
import org.codehaus.cargo.container.internal.util.AntBuildListener;
import org.codehaus.cargo.container.internal.util.AntUtils;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.spi.DefaultDeployableFactory;
import org.codehaus.cargo.util.FileUtils;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public abstract class AbstractContainer
extends MonitoredObject
implements Container {
    private Map systemProperties;
    private String[] extraClasspath;
    private File output;
    private boolean append;
    private File homeDir;
    private JdkUtils jdkUtils;
    private AntUtils antUtils;
    private HttpUtils httpUtils;
    private ResourceUtils resourceUtils;
    private FileUtils fileUtils;
    private long timeout = 60000L;
    private DeployableFactory deployableFactory;
    private Configuration configuration;
    private State state = State.STOPPED;

    public AbstractContainer() {
        this.jdkUtils = new JdkUtils();
        this.fileUtils = new FileUtils();
        this.antUtils = new AntUtils();
        this.resourceUtils = new ResourceUtils();
        this.httpUtils = new HttpUtils();
        this.deployableFactory = new DefaultDeployableFactory();
    }

    protected final HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    protected final JdkUtils getJdkUtils() {
        return this.jdkUtils;
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    protected final FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public final void setHomeDir(File homeDir) {
        this.homeDir = homeDir;
    }

    public final void setHomeDir(String homeDir) {
        this.homeDir = new File(homeDir);
    }

    public final void setOutput(File output) {
        this.output = output;
    }

    public final void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    public void setSystemProperties(Map properties) {
        HashMap props = new HashMap();
        props.putAll(properties);
        this.systemProperties = props;
    }

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public void setExtraClasspath(String[] classpath) {
        this.extraClasspath = classpath;
    }

    public String[] getExtraClasspath() {
        return this.extraClasspath;
    }

    public final File getOutput() {
        return this.output;
    }

    public final boolean isAppend() {
        return this.append;
    }

    public final File getHomeDir() {
        return this.homeDir;
    }

    protected abstract void doStart(Java var1) throws Exception;

    private void verify() {
        if (this.getConfiguration() == null) {
            this.configuration = new DefaultConfigurationFactory().createConfiguration(this, "standalone");
        }
    }

    public final void start() {
        this.getMonitor().info(this.getName() + " starting...", this.getClass().getName());
        this.setState(State.STARTING);
        this.verify();
        try {
            this.doStart(this.createJavaForStartUp());
            this.waitForCompletion(true);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to start the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput().getPath() + "] file " + "containing the container logs for more details."), e);
        }
        this.setState(State.STARTED);
        this.getMonitor().info(this.getName() + " started", this.getClass().getName());
    }

    protected abstract void doStop(Java var1) throws Exception;

    public final void stop() {
        this.getMonitor().info(this.getName() + " is stopping...", this.getClass().getName());
        this.setState(State.STOPPING);
        this.verify();
        try {
            this.doStop(this.createJavaForShutDown());
            this.waitForCompletion(false);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to stop the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput().getPath() + "] file " + "containing the container logs for more details."), e);
        }
        this.setState(State.STOPPED);
        this.getMonitor().info(this.getName() + " is stopped", this.getClass().getName());
    }

    private Java createJavaForShutDown() {
        Java java = (Java)this.getAntUtils().createAntTask("java");
        java.setFork(true);
        java.setOutput(this.getOutput());
        java.setAppend(true);
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getMonitor(), this.getClass().getName()));
        this.addExtraClasspath(java);
        String jvmargs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmargs != null) {
            java.createJvmarg().setLine(jvmargs);
        }
        return java;
    }

    private Java createJavaForStartUp() {
        Java java = (Java)this.getAntUtils().createAntTask("java");
        java.setFork(true);
        java.setOutput(this.getOutput());
        java.setAppend(this.isAppend());
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getMonitor(), this.getClass().getName()));
        this.addExtraClasspath(java);
        this.addSystemProperties(java);
        String jvmargs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmargs != null) {
            java.createJvmarg().setLine(jvmargs);
        }
        return java;
    }

    private void addSystemProperties(Java java) {
        if (this.getSystemProperties() != null) {
            Iterator keys = this.getSystemProperties().keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                java.addSysproperty(this.getAntUtils().createSysProperty(key, (String)this.getSystemProperties().get(key)));
            }
        }
    }

    protected final void addToolsJarToClasspath(Path classpath) throws FileNotFoundException {
        if (!this.getJdkUtils().isOSX()) {
            classpath.createPathElement().setLocation(this.getJdkUtils().getToolsJar());
        }
    }

    private void addExtraClasspath(Java javaCommand) {
        Path classpath = javaCommand.createClasspath();
        if (this.getExtraClasspath() != null) {
            Path path = new Path(this.getAntUtils().createProject());
            for (int i = 0; i < this.getExtraClasspath().length; ++i) {
                Path pathElement = new Path(this.getAntUtils().createProject(), this.getExtraClasspath()[i]);
                path.addExisting(pathElement);
                this.getMonitor().debug("Adding [" + pathElement + "] to execution classpath", this.getClass().getName());
            }
            classpath.addExisting(path);
        }
    }

    protected void verifyHomeDir() {
        if (this.getHomeDir() == null) {
            throw new ContainerException("You must set the mandatory [homeDir] property");
        }
        if (!this.getHomeDir().isDirectory()) {
            throw new ContainerException("[" + this.getHomeDir() + "] is not a valid directory");
        }
    }

    private void waitForCompletion(boolean waitForStarting) throws MalformedURLException, InterruptedException {
        boolean bl;
        boolean exitCondition;
        URL pingURL = new URL("http://" + this.getConfiguration().getPropertyValue("cargo.hostname") + ":" + this.getConfiguration().getPropertyValue("cargo.servlet.port") + "/cargocpc/index.html");
        this.getMonitor().info("Waiting for " + this.getName() + " container " + (waitForStarting ? "start" : "stop") + " using CPC ping URL [" + pingURL.toString() + "]", this.getClass().getName());
        long startTime = System.currentTimeMillis();
        do {
            if (System.currentTimeMillis() - startTime > this.getTimeout()) {
                String message = "Failed to " + (waitForStarting ? "start" : "stop") + " the container after more than [" + this.getTimeout() + "] ms.";
                this.getMonitor().info(message, this.getClass().getName());
                throw new ContainerException(message);
            }
            this.getJdkUtils().sleep(100L);
            HttpUtils.HttpResult pingResult = new HttpUtils.HttpResult();
            boolean isRunning = this.getHttpUtils().ping(pingURL, pingResult);
            if (pingResult.responseCode >= 500) {
                this.getMonitor().warn("Error while pinging CPC URL [" + pingURL.toString() + "], Reason = [" + pingResult.responseMessage + "], Body = [" + pingResult.responseBody + "], Code = [" + pingResult.responseCode, this.getClass().getName());
            }
            if (waitForStarting) {
                if (!isRunning) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = isRunning;
        } while (exitCondition = bl);
        Thread.sleep(2000L);
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public DeployableFactory getDeployableFactory() {
        return this.deployableFactory;
    }

    protected void setDeployableFactory(DeployableFactory factory) {
        this.deployableFactory = factory;
    }
}

