/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.jboss;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.cargo.module.DefaultJarArchive;
import org.codehaus.cargo.module.webapp.jboss.JBossWebXml;
import org.codehaus.cargo.module.webapp.jboss.JBossWebXmlIo;
import org.xml.sax.SAXException;

public class JBossWarArchive {
    private File warFile;
    private JBossWebXml jbossWebXml;

    public JBossWarArchive(File warFile) throws IOException, SAXException, ParserConfigurationException {
        this.warFile = warFile;
        this.jbossWebXml = this.parseJBossWebXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JBossWebXml parseJBossWebXml() throws IOException, SAXException, ParserConfigurationException {
        JBossWebXml webXml = null;
        InputStream in = null;
        try {
            if (this.warFile.isDirectory()) {
                File contextXmlFile = new File(this.warFile, "WEB-INF/jboss-web.xml");
                if (contextXmlFile.exists()) {
                    in = new FileInputStream(contextXmlFile);
                }
            } else {
                DefaultJarArchive jarArchive = new DefaultJarArchive(this.warFile);
                in = jarArchive.getResource("WEB-INF/jboss-web.xml");
            }
            if (in != null) {
                webXml = JBossWebXmlIo.parseJBossWebXml(in);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return webXml;
    }

    public final JBossWebXml getJBossWebXml() {
        return this.jbossWebXml;
    }
}

