/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.tomcat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.cargo.module.DefaultJarArchive;
import org.codehaus.cargo.module.webapp.tomcat.TomcatContextXml;
import org.codehaus.cargo.module.webapp.tomcat.TomcatContextXmlIo;
import org.xml.sax.SAXException;

public class TomcatWarArchive {
    private File warFile;
    private TomcatContextXml tomcatContextXml;

    public TomcatWarArchive(File warFile) throws IOException, SAXException, ParserConfigurationException {
        this.warFile = warFile;
        this.tomcatContextXml = this.parseTomcatContextXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TomcatContextXml parseTomcatContextXml() throws IOException, SAXException, ParserConfigurationException {
        TomcatContextXml context = null;
        InputStream in = null;
        try {
            if (this.warFile.isDirectory()) {
                File contextXmlFile = new File(this.warFile, "META-INF/context.xml");
                if (contextXmlFile.exists()) {
                    in = new FileInputStream(contextXmlFile);
                }
            } else {
                DefaultJarArchive jarArchive = new DefaultJarArchive(this.warFile);
                in = jarArchive.getResource("META-INF/context.xml");
            }
            if (in != null) {
                context = TomcatContextXmlIo.parseTomcatConfigXml(in);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return context;
    }

    public final TomcatContextXml getTomcatContextXml() {
        return this.tomcatContextXml;
    }
}

