/*
 * @(#)AuthenticationAuthorityTest.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.authority;

import java.util.Date;

import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;

import info.dragonlady.sso.Requester;
import info.dragonlady.sso.util.AssertionParser;
import junit.framework.TestCase;

/**
 * AuthenticationAuthorityNXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/06/06 20:19:47 $
 */
public class AuthenticationAuthorityTest extends TestCase {

	/**
	 * @param arg0
	 */
	public AuthenticationAuthorityTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.authority.AuthenticationAuthority#query(org.opensaml.SAMLRequest)} ̂߂̃eXgE\bhB
	 */
	public final void testQuery() {
		try {
			// ̏ꍇ
			String authId = "authId";
			String confirmationMethod = "confirmationMethod";
			String confirmationData = "confirmationData";
			String authMethod = "authMethod";

			TestAuthenticationAuthority authority = new TestAuthenticationAuthority();
			authority.setResult(true);
			SAMLRequest request = Requester.createAuthenticationRequest(null, null, authId, confirmationMethod, confirmationData, authMethod);
			SAMLResponse response = authority.query(request);

			assertEquals(response.getStatus().getCodes().next(), SAMLException.SUCCESS);
			SAMLAssertion assertion = (SAMLAssertion)response.getAssertions().next();
			AssertionParser parser = new AssertionParser(assertion);
			assertTrue(parser.getName().equals(authId));
			assertTrue(parser.getAuthenticationStatement().getSubject().getConfirmationMethods().next().equals(confirmationMethod));
			assertTrue(parser.getAuthenticationStatement().getAuthMethod().equals(authMethod));
			assertTrue(assertion.getNotOnOrAfter().getTime() > new Date().getTime());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.authority.AuthenticationAuthority#query(org.opensaml.SAMLRequest)} ̂߂̃eXgE\bhB
	 */
	public final void testQuery2() {
		try {
			// s̏ꍇ
			String authId = "authId";
			String confirmationMethod = "confirmationMethod";
			String confirmationData = "confirmationData";
			String authMethod = "authMethod";

			TestAuthenticationAuthority authority = new TestAuthenticationAuthority();
			authority.setResult(false);
			SAMLRequest request = Requester.createAuthenticationRequest(null, null, authId, confirmationMethod, confirmationData, authMethod);
			SAMLResponse response = authority.query(request);

			assertEquals(response.getStatus().getCodes().next(), SAMLException.RESPONDER);
			assertTrue(!response.getAssertions().hasNext());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
