/*
 * @(#)AuthorityExceptionTest.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.authority;

import info.dragonlady.sso.authority.AuthorityException;
import junit.framework.TestCase;

/**
 * AuthorityExceptionNXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/06/06 20:16:39 $
 */
public class AuthorityExceptionTest extends TestCase {

	/**
	 * @param arg0
	 */
	public AuthorityExceptionTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.authority.AuthorityException#AuthorityException()} ̂߂̃eXgE\bhB
	 */
	public final void testAuthorityException() {
		try {
			new AuthorityException();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.authority.AuthorityException#AuthorityException(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testAuthorityExceptionString() {
		try {
			String message = "message";
			new AuthorityException(message);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.authority.AuthorityException#AuthorityException(java.lang.Throwable)} ̂߂̃eXgE\bhB
	 */
	public final void testAuthorityExceptionThrowable() {
		try {
			Exception e = new Exception("exception_message");
			new AuthorityException(e);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.authority.AuthorityException#AuthorityException(java.lang.String, java.lang.Throwable)} ̂߂̃eXgE\bhB
	 */
	public final void testAuthorityExceptionStringThrowable() {
		try {
			String message = "message";
			Exception e = new Exception("exception_message");
			new AuthorityException(message, e);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
