/*
 * @(#)TestAttributeAuthority.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.authority;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import info.dragonlady.sso.authority.AttributeAuthority;
import info.dragonlady.sso.authority.AuthorityException;

/**
 * I[\eB̃eXgpNXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/06/05 19:43:35 $
 */
public class TestAttributeAuthority extends AttributeAuthority {

	private boolean success = true;

	public TestAttributeAuthority() {
	}

	public void setResult(boolean success) {
		this.success = success;
	}

	/* (non-Javadoc)
	 * @see info.dragonlady.sso.authority.AttributeAuthority#getAttributes(java.lang.String, java.util.List)
	 */
	@Override
	protected Map<String, List<String>> getAttributes(String authId,
			List<String> attributeNames) throws AuthorityException {
		if(!success || !authId.startsWith("authId")) {
			throw new AuthorityException();
		}
		Map<String, List<String>> attributes = new HashMap<String, List<String>>();
		for(int i = 0; i < attributeNames.size(); i++) {
			String key = attributeNames.get(i).toString();
			List<String> list = new ArrayList<String>();
			list.add("val_" + key);
			attributes.put(key, list);
		}
		return attributes;
	}

}
