/*
 * @(#)TestPolicyDecisionPoint.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.authority;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.opensaml.SAMLAction;
import org.opensaml.SAMLDecision;

import info.dragonlady.sso.SSOConstants;
import info.dragonlady.sso.authority.AuthorityException;
import info.dragonlady.sso.authority.PolicyDecisionPoint;

/**
 * |V[_̃eXgpNXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/06/05 19:45:51 $
 */
public class TestPolicyDecisionPoint extends PolicyDecisionPoint {

	private List<SAMLAction> actions = new ArrayList<SAMLAction>();

	private boolean success = true;

	public TestPolicyDecisionPoint() {
	}

	public void setActions(List<SAMLAction> actions) {
		this.actions = actions;
	}

	public void setResult(boolean success) {
		this.success = success;
	}

	/* (non-Javadoc)
	 * @see info.dragonlady.sso.authority.PolicyDecisionPoint#decide(java.lang.String, java.util.Map, java.util.Iterator, java.lang.String)
	 */
	@Override
	protected String decide(String authId,
			Map<String, List<String>> attributes,
			Iterator<SAMLAction> requestedAction, String resource)
			throws AuthorityException {
		if(!success) {
			throw new AuthorityException();
		}
		return authId.equals("authId") ? SAMLDecision.PERMIT : SAMLDecision.DENY;
	}

	/* (non-Javadoc)
	 * @see info.dragonlady.sso.authority.PolicyDecisionPoint#getPermittedAction(java.lang.String, java.util.Map, java.lang.String)
	 */
	@Override
	protected List<SAMLAction> getPermittedAction(String authId,
			Map<String, List<String>> attributes, String resource)
			throws AuthorityException {
		try {
			if(authId.equals("authId")) {
				actions.add(new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_GET));
				actions.add(new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_POST));
			}
		} catch(Exception e) {
			throw new AuthorityException(e);
		}
		return actions;
	}

}
