/*
 * @(#)AssertionGeneratorTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLDecision;
import org.opensaml.SAMLSubject;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.SAMLArtifactType0001;

import info.dragonlady.sso.SSOConstants;
import info.dragonlady.sso.util.AssertionGenerator;
import info.dragonlady.sso.util.AssertionParser;
import junit.framework.TestCase;

/**
 * AssertionGeneratorNX̃eXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/01 13:17:32 $
 */
public class AssertionGeneratorTest extends TestCase {

	/**
	 * @param arg0
	 */
	public AssertionGeneratorTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionGenerator#generateArtifact(byte[])} ̂߂̃eXgE\bhB
	 */
	public final void testGenerateArtifact() {
		try {
			byte[] handle = new byte[20];
			Artifact artifact = AssertionGenerator.generateArtifact(handle);
			assertTrue(Arrays.equals(handle, ((SAMLArtifactType0001)SAMLArtifactType0001.TYPE_CODE.getParser().parse(artifact.encode())).getAssertionHandle()));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionGenerator#generateAuthenticationAssertion(java.lang.String, java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testGenerateAuthenticationAssertion() {
		try {
			String authId = "dummyId";
			String confirmationMethod = SAMLSubject.CONF_ARTIFACT;
			String authMethod = SAMLAuthenticationStatement.AuthenticationMethod_Unspecified;
			SAMLAssertion assertion = AssertionGenerator.generateAuthenticationAssertion(authId, confirmationMethod, authMethod);
			AssertionParser parser = new AssertionParser(assertion);
			assertTrue(parser.getName().equals(authId));
			assertTrue(parser.getAuthenticationStatement().getSubject().getConfirmationMethods().next().equals(confirmationMethod));
			assertTrue(parser.getAuthenticationStatement().getAuthMethod().equals(authMethod));
			assertTrue(assertion.getNotOnOrAfter().getTime() > new Date().getTime());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionGenerator#generateAttributeAssertion(java.lang.String, java.util.Map)} ̂߂̃eXgE\bhB
	 */
	public final void testGenerateAttributeAssertion() {
		try {
			String authId = "dummyId";
			Map<String, List<String>> attributes = new HashMap<String, List<String>>();
			List<String> values = new ArrayList<String>();
			values.add("testValue1");
			values.add("testValue2");
			attributes.put("testAttribute1", values);

			SAMLAssertion assertion = AssertionGenerator.generateAttributeAssertion(authId, attributes);
			AssertionParser parser = new AssertionParser(assertion);
			assertTrue(parser.getAttributeStatement().getSubject().getNameIdentifier().getName().equals(authId));
			assertTrue(parser.getAttribute().equals(attributes));
			assertTrue(assertion.getNotOnOrAfter().getTime() > new Date().getTime());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionGenerator#generateAuthorizationDecisionAssertion(java.lang.String, java.lang.String, java.lang.String, java.util.List)} ̂߂̃eXgE\bhB
	 */
	public final void testGenerateAuthorizationDecisionAssertion() {
		try {
			String authId = "dummyId";
			String resource = "dummyResource";
			String decision = SAMLDecision.DENY;
			List<SAMLAction> actions = new ArrayList<SAMLAction>();
			actions.add(new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_GET));
			actions.add(new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_POST));

			SAMLAssertion assertion = AssertionGenerator.generateAuthorizationDecisionAssertion(authId, resource, decision, actions);
			AssertionParser parser = new AssertionParser(assertion);
			assertTrue(parser.getDecisionStatement().getSubject().getNameIdentifier().getName().equals(authId));
			assertTrue(parser.getResource().equals(resource));
			assertTrue(parser.getDecisionStatement().getDecision().equals(decision));
			Iterator<SAMLAction> itr = actions.iterator();
			Iterator<SAMLAction> actionItr = parser.getDecisionStatement().getActions();
			while(itr.hasNext()) {
				assertTrue(actionItr.hasNext());
				assertTrue(itr.next().equals(actionItr.next()));
			}
			assertTrue(assertion.getNotOnOrAfter().getTime() > new Date().getTime());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
