/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.cluster;

import info.dragonlady.cluster.UserService;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.message.SSOMessageResource;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;

public class UserServiceImpl
extends UnicastRemoteObject
implements UserService {
    public UserServiceImpl() throws RemoteException {
    }

    public UserServiceImpl(int port) throws RemoteException {
        super(port);
    }

    public UserServiceImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    public synchronized boolean add(String userName, String relationId) throws RemoteException {
        try {
            LoginManager lm = LoginManager.getInstance();
            if (!lm.isLoggedIn(userName)) {
                lm.add(userName, relationId);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            throw new RemoteException(message, e);
        }
    }

    public synchronized boolean remove(String userName) throws RemoteException {
        try {
            LoginManager lm = LoginManager.getInstance();
            if (lm.isLoggedIn(userName)) {
                lm.remove(userName);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            throw new RemoteException(message, e);
        }
    }

    public boolean removeByRelationId(String relationId) throws RemoteException {
        try {
            LoginManager lm = LoginManager.getInstance();
            lm.removeById(relationId);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            throw new RemoteException(message, e);
        }
    }

    public synchronized Map get() throws RemoteException {
        try {
            LoginManager lm = LoginManager.getInstance();
            Map map = lm.getMap();
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            RemoteException ex = new RemoteException(message);
            ex.initCause(e);
            throw ex;
        }
    }

    public synchronized void set(Map users) throws RemoteException {
        try {
            LoginManager lm = LoginManager.getInstance();
            lm.setMap(users);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            RemoteException ex = new RemoteException(message);
            ex.initCause(e);
            throw ex;
        }
    }
}

