/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.crypto;

import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class DHTest {
    public static void main(String[] args) throws Exception {
        DHTest test = new DHTest();
        Bob bob = test.new Bob();
        DHTest dHTest = test;
        dHTest.getClass();
        Alice alice = dHTest.new Alice(bob);
        alice.generateSecretKey();
        System.out.println("Alice secret: " + DHTest.toHexString(alice.getSecretKey().getEncoded()));
        System.out.println("Alice secret: " + DHTest.toHexString(alice.getSecretKeyByte()));
        System.out.println("Bob secret: " + DHTest.toHexString(bob.getSecretKeyByte()));
    }

    private static String toHexString(byte[] arr) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < arr.length) {
            buf.append(Integer.toHexString(arr[i] & 0xFF));
            ++i;
        }
        return buf.toString();
    }

    public class Alice {
        private Bob bob_;
        private SecretKey secretKey_;
        private byte[] secretKeyByte_;

        public Alice(Bob bob) {
            this.bob_ = bob;
        }

        public void generateSecretKey() throws Exception {
            AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DH");
            paramGen.init(512);
            AlgorithmParameters params = paramGen.generateParameters();
            DHParameterSpec dhSkipParamSpec = params.getParameterSpec(DHParameterSpec.class);
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("DH");
            keyPairGen.initialize(dhSkipParamSpec);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            KeyAgreement keyAgree = KeyAgreement.getInstance("DH");
            keyAgree.init(keyPair.getPrivate());
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(this.bob_.createPublicKeyEncode(keyPair.getPublic().getEncoded()));
            PublicKey destinationPubKey = KeyFactory.getInstance("DH").generatePublic(x509KeySpec);
            keyAgree.doPhase(destinationPubKey, true);
            this.bob_.setKeyLength(keyAgree.generateSecret().length);
            keyAgree.doPhase(destinationPubKey, true);
            this.secretKeyByte_ = keyAgree.generateSecret();
            keyAgree.init(keyPair.getPrivate());
            keyAgree.doPhase(destinationPubKey, true);
            this.secretKey_ = keyAgree.generateSecret("Blowfish");
        }

        public SecretKey getSecretKey() {
            return this.secretKey_;
        }

        public byte[] getSecretKeyByte() {
            return this.secretKeyByte_;
        }
    }

    public class Bob {
        private SecretKey secretKey_;
        private KeyAgreement keyAgree_;
        private PublicKey publicKey_;
        private byte[] secretKeyByte_;

        public byte[] createPublicKeyEncode(byte[] pubKeyEnc) throws Exception {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKeyEnc);
            this.publicKey_ = KeyFactory.getInstance("DH").generatePublic(x509KeySpec);
            DHParameterSpec dhParamSpec = ((DHPublicKey)this.publicKey_).getParams();
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("DH");
            keyPairGen.initialize(dhParamSpec);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            this.keyAgree_ = KeyAgreement.getInstance("DH");
            this.keyAgree_.init(keyPair.getPrivate());
            return keyPair.getPublic().getEncoded();
        }

        public void setKeyLength(int len) throws Exception {
            int myLen;
            byte[] secret = new byte[len];
            try {
                this.keyAgree_.doPhase(this.publicKey_, true);
                myLen = this.keyAgree_.generateSecret(secret, 1);
            }
            catch (ShortBufferException e) {
                System.out.println(e.getMessage());
            }
            myLen = this.keyAgree_.generateSecret(secret, 0);
            System.out.println("mylen:" + myLen);
            System.out.println("secret:" + DHTest.toHexString(secret));
            this.keyAgree_.doPhase(this.publicKey_, true);
            this.secretKeyByte_ = this.keyAgree_.generateSecret();
        }

        public SecretKey getSecretKey() {
            return this.secretKey_;
        }

        public byte[] getSecretKeyByte() {
            return this.secretKeyByte_;
        }
    }
}

